/*
 * Decompiled with CFR 0.152.
 */
package com.thanatoros.bettercoppergolem.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.thanatoros.bettercoppergolem.config.ModConfigs;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.coppergolem.CopperGolemAi;
import net.minecraft.world.entity.animal.coppergolem.CopperGolemState;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CopperGolemAi.class})
public abstract class CopperGolemAiMixin {
    @Shadow
    private static final Predicate<BlockState> TRANSPORT_ITEM_SOURCE_BLOCK = p_428358_ -> p_428358_.is(BlockTags.COPPER_CHESTS);
    @Shadow
    private static final Predicate<BlockState> TRANSPORT_ITEM_DESTINATION_BLOCK = p_426042_ -> p_426042_.is(Blocks.CHEST) || p_426042_.is(Blocks.TRAPPED_CHEST);

    @Overwrite
    private static void initIdleActivity(Brain<CopperGolem> p_428622_) {
        int vertical = (int)Math.floor((double)ModConfigs.VERTICAL_RANGE / 2.0);
        int horizontal = (int)Math.floor((double)ModConfigs.HORIZONTAL_RANGE / 2.0);
        if (vertical > 200) {
            vertical = 200;
        } else if (vertical < 2) {
            vertical = 2;
        }
        if (horizontal > 1000) {
            horizontal = 1000;
        } else if (horizontal < 4) {
            horizontal = 4;
        }
        p_428622_.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new TransportItemsBetweenContainers(1.0f, TRANSPORT_ITEM_SOURCE_BLOCK, TRANSPORT_ITEM_DESTINATION_BLOCK, horizontal, vertical, CopperGolemAiMixin.getTargetReachedInteractions(), CopperGolemAiMixin.onTravelling(), CopperGolemAiMixin.shouldQueueForTarget())), (Object)Pair.of((Object)1, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)40, (int)80))), (Object)Pair.of((Object)2, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_PRESENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f, (int)2, (int)2), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    @Shadow
    private static Predicate<TransportItemsBetweenContainers.TransportItemTarget> shouldQueueForTarget() {
        return p_424241_ -> {
            ChestBlockEntity chestblockentity;
            BlockEntity patt0$temp = p_424241_.blockEntity();
            return patt0$temp instanceof ChestBlockEntity ? !(chestblockentity = (ChestBlockEntity)patt0$temp).getEntitiesWithContainerOpen().isEmpty() : false;
        };
    }

    @Shadow
    private static Consumer<PathfinderMob> onTravelling() {
        return p_425830_ -> {
            if (p_425830_ instanceof CopperGolem) {
                CopperGolem coppergolem = (CopperGolem)p_425830_;
                coppergolem.clearOpenedChestPos();
                coppergolem.setState(CopperGolemState.IDLE);
            }
        };
    }

    @Shadow
    private static Map<TransportItemsBetweenContainers.ContainerInteractionState, TransportItemsBetweenContainers.OnTargetReachedInteraction> getTargetReachedInteractions() {
        return Map.of(TransportItemsBetweenContainers.ContainerInteractionState.PICKUP_ITEM, CopperGolemAiMixin.onReachedTargetInteraction(CopperGolemState.GETTING_ITEM, SoundEvents.COPPER_GOLEM_ITEM_GET), TransportItemsBetweenContainers.ContainerInteractionState.PICKUP_NO_ITEM, CopperGolemAiMixin.onReachedTargetInteraction(CopperGolemState.GETTING_NO_ITEM, SoundEvents.COPPER_GOLEM_ITEM_NO_GET), TransportItemsBetweenContainers.ContainerInteractionState.PLACE_ITEM, CopperGolemAiMixin.onReachedTargetInteraction(CopperGolemState.DROPPING_ITEM, SoundEvents.COPPER_GOLEM_ITEM_DROP), TransportItemsBetweenContainers.ContainerInteractionState.PLACE_NO_ITEM, CopperGolemAiMixin.onReachedTargetInteraction(CopperGolemState.DROPPING_NO_ITEM, SoundEvents.COPPER_GOLEM_ITEM_NO_DROP));
    }

    @Shadow
    private static TransportItemsBetweenContainers.OnTargetReachedInteraction onReachedTargetInteraction(CopperGolemState p_429539_, @Nullable SoundEvent p_426594_) {
        return (p_425723_, p_428413_, p_430305_) -> {
            if (p_425723_ instanceof CopperGolem) {
                CopperGolem coppergolem = (CopperGolem)p_425723_;
                Container container = p_428413_.container();
                if (p_430305_ == 1) {
                    container.startOpen((ContainerUser)coppergolem);
                    coppergolem.setOpenedChestPos(p_428413_.pos());
                    coppergolem.setState(p_429539_);
                }
                if (p_430305_ == 9 && p_426594_ != null) {
                    coppergolem.playSound(p_426594_);
                }
                if (p_430305_ == 60) {
                    if (container.getEntitiesWithContainerOpen().contains(p_425723_)) {
                        container.stopOpen((ContainerUser)coppergolem);
                    }
                    coppergolem.clearOpenedChestPos();
                }
            }
        };
    }
}

