/*
 * Decompiled with CFR 0.152.
 */
package com.thanatoros.bettercoppergolem.config;

import com.mojang.datafixers.util.Pair;
import com.thanatoros.bettercoppergolem.config.BetterCopperGolemConfig;
import com.thanatoros.bettercoppergolem.config.ModConfigProvider;
import java.io.IOException;

public class ModConfigs {
    public static BetterCopperGolemConfig CONFIG;
    private static ModConfigProvider configs;
    public static int OPERATION_MODE;
    public static int MOVEMENT_SPEED;
    public static int CARRY_SIZE;
    public static int VERTICAL_RANGE;
    public static int HORIZONTAL_RANGE;
    public static int MAX_HEALTH;
    public static int INTERACTION_SPEED;
    public static int MAX_CHESTS;
    public static int POTION_TYPES;
    public static String[] configsStrings;
    public static String[] descStrings;
    public static String[][] oldDescStrings;

    public static void registerConfigs() throws IOException {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = BetterCopperGolemConfig.of("bettercoppergolemconfig").provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"OPERATION_MODE", (Object)19), "Avaible operation mods and their explanation at https://modrinth.com/mod/better-copper-golem");
        configs.addKeyValuePair(new Pair((Object)"MOVEMENT_SPEED", (Object)1), "Copper Golem speed modifier [min:1, max:10]");
        configs.addKeyValuePair(new Pair((Object)"CARRY_SIZE", (Object)16), "Copper Golem carry size [min:8, max:64] | default: 16");
        configs.addKeyValuePair(new Pair((Object)"VERTICAL_RANGE", (Object)16), "Copper Golem vertical range search modifier [min:2, max:200]");
        configs.addKeyValuePair(new Pair((Object)"HORIZONTAL_RANGE", (Object)64), "Copper Golem horizontal range search modifier [min:4, max:1000]");
        configs.addKeyValuePair(new Pair((Object)"MAX_HEALTH", (Object)12), "Copper Golem health [min:6, max:64] | default: 12");
        configs.addKeyValuePair(new Pair((Object)"INTERACTION_SPEED", (Object)60), "Copper Golem interaction speed modifier [min:1, max:300] ticks (20 ticks = 1s)");
        configs.addKeyValuePair(new Pair((Object)"MAX_CHESTS", (Object)10), "How many chests Copper Golem checks [min:1, max:1000] | default: 10");
        configs.addKeyValuePair(new Pair((Object)"POTION_TYPES", (Object)1), "1: dont ignore potion types, 0: ignore potion types, -1: ignore potion types but sort tipped arrows separately (ignoring potion types means that for example lingering potion of regen will be sorted with splash poting of regen)");
    }

    private static void assignConfigs() throws IOException {
        OPERATION_MODE = CONFIG.getOrDefault("OPERATION_MODE", 19);
        MOVEMENT_SPEED = CONFIG.getOrDefault("MOVEMENT_SPEED", 1);
        CARRY_SIZE = CONFIG.getOrDefault("CARRY_SIZE", 16);
        VERTICAL_RANGE = CONFIG.getOrDefault("VERTICAL_RANGE", 16);
        HORIZONTAL_RANGE = CONFIG.getOrDefault("HORIZONTAL_RANGE", 64);
        MAX_HEALTH = CONFIG.getOrDefault("MAX_HEALTH", 12);
        INTERACTION_SPEED = CONFIG.getOrDefault("INTERACTION_SPEED", 60);
        MAX_CHESTS = CONFIG.getOrDefault("MAX_CHESTS", 10);
        POTION_TYPES = CONFIG.getOrDefault("POTION_TYPES", 1);
    }

    static {
        configsStrings = new String[]{"OPERATION_MODE=19 #Avaible operation mods and their explanation at https://modrinth.com/mod/better-copper-golem | default: 19", "MOVEMENT_SPEED=1 #Copper Golem speed modifier [min:1, max:10] | default: 1", "CARRY_SIZE=16 #Copper Golem carry size [min:8, max:64] | default: 16", "VERTICAL_RANGE=16 #Copper Golem vertical range search modifier [min:2, max:200] | default: 16", "HORIZONTAL_RANGE=64 #Copper Golem horizontal range search modifier [min:4, max:1000] | default: 64", "MAX_HEALTH=12 #Copper Golem health [min:6, max:64] | default: 12", "INTERACTION_SPEED=60 #Copper Golem interaction speed modifier [min:1, max:300] ticks (20 ticks = 1s) | default: 60", "MAX_CHESTS=10 #How many chests Copper Golem checks [min:1, max:1000] | default: 10", "POTION_TYPES=1 #1: dont ignore potion types, 0: ignore potion types, -1: ignore potion types but sort tipped arrows separately (ignoring potion types means that for example lingering potion of regen will be sorted with splash poting of regen)"};
        descStrings = new String[]{"#Avaible operation mods and their explanation at https://modrinth.com/mod/better-copper-golem", "#Copper Golem speed modifier [min:1, max:10] | default: 1", "#Copper Golem carry size [min:8, max:64] | default: 16", "#Copper Golem vertical range search modifier [min:2, max:200] | default: 16", "#Copper Golem horizontal range search modifier [min:4, max:1000] | default: 64", "#Copper Golem health [min:6, max:64] | default: 12", "#Copper Golem interaction speed modifier [min:1, max:300] ticks (20 ticks = 1s) | default: 60", "#How many chests Copper Golem checks [min:1, max:1000] | default: 10", "#1: dont ignore potion types, 0: ignore potion types, -1: ignore potion types but sort tipped arrows separately (ignoring potion types means that for example lingering potion of regen will be sorted with splash poting of regen)"};
        oldDescStrings = new String[][]{{"XXYYZZ", "XXYYZZ"}, {"#Copper Golem speed modifier [min:1, max:4] | default: 1", "XXYYZZ"}, {"XXYYZZ", "XXYYZZ"}, {"XXYYZZ", "XXYYZZ"}, {"XXYYZZ", "XXYYZZ"}, {"XXYYZZ", "XXYYZZ"}, {"XXYYZZ", "XXYYZZ"}, {"XXYYZZ", "XXYYZZ"}, {"XXYYZZ", "XXYYZZ"}};
    }
}

