/*
 * Decompiled with CFR 0.152.
 */
package com.thanatoros.bettercoppergolem.mixin;

import com.google.common.collect.ImmutableMap;
import com.thanatoros.bettercoppergolem.config.ModConfigs;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={TransportItemsBetweenContainers.class})
public abstract class BetterCopperGolemMixin
extends Behavior<PathfinderMob> {
    @Shadow
    private final float speedModifier;
    @Shadow
    private final Predicate<BlockState> sourceBlockType;
    @Shadow
    private final Predicate<BlockState> destinationBlockType;
    @Shadow
    private final int horizontalSearchDistance;
    @Shadow
    private final int verticalSearchDistance;
    @Shadow
    private final Consumer<PathfinderMob> onStartTravelling;
    @Shadow
    private final Map<TransportItemsBetweenContainers.ContainerInteractionState, TransportItemsBetweenContainers.OnTargetReachedInteraction> onTargetInteractionActions;
    @Shadow
    private final Predicate<TransportItemsBetweenContainers.TransportItemTarget> shouldQueueForTarget;
    @Shadow
    private TransportItemsBetweenContainers.TransportItemState state;
    @Shadow
    private int ticksSinceReachingTarget;

    public BetterCopperGolemMixin(float p_424497_, Predicate<BlockState> p_430226_, Predicate<BlockState> p_431607_, int p_422794_, int p_426431_, Map<TransportItemsBetweenContainers.ContainerInteractionState, TransportItemsBetweenContainers.OnTargetReachedInteraction> p_427019_, Consumer<PathfinderMob> p_431304_, Predicate<TransportItemsBetweenContainers.TransportItemTarget> p_422647_) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.VISITED_BLOCK_POSITIONS, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = p_424497_;
        this.sourceBlockType = p_430226_;
        this.destinationBlockType = p_431607_;
        this.horizontalSearchDistance = p_422794_;
        this.verticalSearchDistance = p_426431_;
        this.onStartTravelling = p_431304_;
        this.shouldQueueForTarget = p_422647_;
        this.onTargetInteractionActions = p_427019_;
        this.state = TransportItemsBetweenContainers.TransportItemState.TRAVELLING;
    }

    @Overwrite
    protected void onReachedTarget(TransportItemsBetweenContainers.TransportItemTarget p_431168_, Level p_423012_, PathfinderMob p_431642_) {
        int interaction_speed = ModConfigs.INTERACTION_SPEED;
        if (interaction_speed > 300) {
            interaction_speed = 300;
        } else if (interaction_speed < 1) {
            interaction_speed = 1;
        }
        if (!this.isWithinTargetDistance(2.0, p_431168_, p_423012_, p_431642_, this.getCenterPos(p_431642_))) {
            this.onStartTravelling(p_431642_);
        } else {
            ++this.ticksSinceReachingTarget;
            this.onTargetInteraction(p_431168_, p_431642_);
            if (this.ticksSinceReachingTarget >= interaction_speed) {
                this.doReachedTargetInteraction(p_431642_, p_431168_.container(), this::pickUpItems, (p_430921_, p_425673_) -> this.stopTargetingCurrentTarget(p_431642_), this::putDownItem, (p_431419_, p_423494_) -> this.stopTargetingCurrentTarget(p_431642_));
                this.onStartTravelling(p_431642_);
            }
        }
    }

    @Shadow
    abstract boolean isWithinTargetDistance(double var1, TransportItemsBetweenContainers.TransportItemTarget var3, Level var4, PathfinderMob var5, Vec3 var6);

    @Shadow
    abstract Vec3 getCenterPos(PathfinderMob var1);

    @Shadow
    abstract void onStartTravelling(PathfinderMob var1);

    @Shadow
    abstract void onTargetInteraction(TransportItemsBetweenContainers.TransportItemTarget var1, PathfinderMob var2);

    @Shadow
    abstract void doReachedTargetInteraction(PathfinderMob var1, Container var2, BiConsumer<PathfinderMob, Container> var3, BiConsumer<PathfinderMob, Container> var4, BiConsumer<PathfinderMob, Container> var5, BiConsumer<PathfinderMob, Container> var6);

    @Shadow
    abstract void pickUpItems(PathfinderMob var1, Container var2);

    @Shadow
    abstract void putDownItem(PathfinderMob var1, Container var2);

    @Shadow
    abstract void stopTargetingCurrentTarget(PathfinderMob var1);

    @Overwrite
    private static ItemStack pickupItemFromContainer(Container p_422876_) {
        int i = 0;
        int carry_size = ModConfigs.CARRY_SIZE;
        if (carry_size > 64) {
            carry_size = 64;
        } else if (carry_size < 8) {
            carry_size = 8;
        }
        for (ItemStack itemstack : p_422876_) {
            if (!itemstack.isEmpty()) {
                int j = Math.min(itemstack.getCount(), carry_size);
                return p_422876_.removeItem(i, j);
            }
            ++i;
        }
        return ItemStack.EMPTY;
    }

    @Overwrite
    protected void setVisitedBlockPos(PathfinderMob p_428904_, Level p_424578_, BlockPos p_430799_) {
        int chests = ModConfigs.MAX_CHESTS;
        if (chests > 1000) {
            chests = 1000;
        } else if (chests < 1) {
            chests = 1;
        }
        HashSet<GlobalPos> set = new HashSet<GlobalPos>(BetterCopperGolemMixin.getVisitedPositions(p_428904_));
        set.add(new GlobalPos(p_424578_.dimension(), p_430799_));
        if (set.size() > chests) {
            this.enterCooldownAfterNoMatchingTargetFound(p_428904_);
        } else {
            p_428904_.getBrain().setMemoryWithExpiry(MemoryModuleType.VISITED_BLOCK_POSITIONS, set, 6000L);
        }
    }

    @Shadow
    static Set<GlobalPos> getVisitedPositions(PathfinderMob p_423632_) {
        return null;
    }

    @Shadow
    abstract void enterCooldownAfterNoMatchingTargetFound(PathfinderMob var1);

    @Overwrite
    private static boolean hasItemMatchingHandItem(PathfinderMob p_430719_, Container p_426288_) {
        ItemStack itemStack = p_430719_.getMainHandItem();
        boolean result = false;
        boolean count = false;
        for (ItemStack stack : p_426288_) {
            Item item = itemStack.getItem();
            if (!((item.toString().contains("potion") || item.toString().contains("splash_potion") || item.toString().contains("lingering_potion") || item.toString().contains("tipped_arrow")) && (stack.getItem().toString().contains("potion") || stack.getItem().toString().contains("splash_potion") || stack.getItem().toString().contains("lingering_potion") || stack.getItem().toString().contains("tipped_arrow")))) {
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack)) continue;
                return true;
            }
            int mode = 1;
            if (ModConfigs.OPERATION_MODE <= 4 || ModConfigs.OPERATION_MODE >= 9 && ModConfigs.OPERATION_MODE <= 19) {
                mode = 0;
            }
            switch (ModConfigs.OPERATION_MODE) {
                case 1: 
                case 5: {
                    if (item.toString().equals("potion") && stack.getItem().toString().equals("potion")) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 2: 
                case 6: {
                    if (item.toString().equals("splash_potion") && stack.getItem().toString().equals("splash_potion")) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 3: 
                case 7: {
                    if (item.toString().equals("lingering_potion") && stack.getItem().toString().equals("lingering_potion")) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 4: 
                case 8: {
                    if (item.toString().equals("tipped_arrow") && stack.getItem().toString().equals("tipped_arrow")) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 9: 
                case 20: {
                    if ((item.toString().equals("potion") || item.toString().equals("splash_potion")) && (stack.getItem().toString().equals("potion") || stack.getItem().toString().equals("splash_potion"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 10: 
                case 21: {
                    if ((item.toString().equals("potion") || item.toString().equals("lingering_potion")) && (stack.getItem().toString().equals("potion") || stack.getItem().toString().equals("lingering_potion"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 11: 
                case 22: {
                    if ((item.toString().equals("potion") || item.toString().equals("tipped_arrow")) && (stack.getItem().toString().equals("potion") || stack.getItem().toString().equals("tipped_arrow"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 12: 
                case 23: {
                    if ((item.toString().equals("splash_potion") || item.toString().equals("lingering_potion")) && (stack.getItem().toString().equals("splash_potion") || stack.getItem().toString().equals("lingering_potion"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 13: 
                case 24: {
                    if ((item.toString().equals("splash_potion") || item.toString().equals("tipped_arrow")) && (stack.getItem().toString().equals("splash_potion") || stack.getItem().toString().equals("tipped_arrow"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 14: 
                case 25: {
                    if ((item.toString().equals("lingering_potion") || item.toString().equals("tipped_arrow")) && (stack.getItem().toString().equals("lingering_potion") || stack.getItem().toString().equals("tipped_arrow"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 15: 
                case 26: {
                    if ((item.toString().equals("potion") || item.toString().equals("splash_potion") || item.toString().equals("lingering_potion")) && (stack.getItem().toString().equals("potion") || stack.getItem().toString().equals("splash_potion") || stack.getItem().toString().equals("lingering_potion"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 16: 
                case 27: {
                    if ((item.toString().equals("splash_potion") || item.toString().equals("lingering_potion") || item.toString().equals("tipped_arrow")) && (stack.getItem().toString().equals("splash_potion") || stack.getItem().toString().equals("lingering_potion") || stack.getItem().toString().equals("tipped_arrow"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 17: 
                case 28: {
                    if ((item.toString().equals("potion") || item.toString().equals("lingering_potion") || item.toString().equals("tipped_arrow")) && (stack.getItem().toString().equals("potion") || stack.getItem().toString().equals("lingering_potion") || stack.getItem().toString().equals("tipped_arrow"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 18: 
                case 29: {
                    if ((item.toString().equals("potion") || item.toString().equals("splash_potion") || item.toString().equals("tipped_arrow")) && (stack.getItem().toString().equals("potion") || stack.getItem().toString().equals("splash_potion") || stack.getItem().toString().equals("tipped_arrow"))) {
                        result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                        break;
                    }
                    result = ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack);
                    break;
                }
                case 19: 
                case 30: {
                    result = BetterCopperGolemMixin.isItemEqualMINE(stack, itemStack, mode);
                }
            }
        }
        return !itemStack.isEmpty() && result;
    }

    private static boolean isItemEqualMINE(ItemStack stack, ItemStack itemStack, int mode) {
        return !stack.isEmpty() && BetterCopperGolemMixin.isOfMINE(stack, itemStack, mode);
    }

    private static boolean isOfMINE(ItemStack stack, ItemStack itemStack, int mode) {
        PotionContents potionContentsComponent = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
        PotionContents potionContentsComponent2 = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        Object handNbt = potionContentsComponent.potion().toString();
        handNbt = ((String)handNbt).substring(((String)handNbt).indexOf(" ") + 1);
        handNbt = ((String)handNbt).substring(0, ((String)handNbt).indexOf("]"));
        handNbt = ((String)handNbt).replace("/ ", "");
        handNbt = "\"" + (String)handNbt + "\"";
        Object gotNbt = potionContentsComponent2.potion().toString();
        gotNbt = ((String)gotNbt).substring(((String)gotNbt).indexOf(" ") + 1);
        gotNbt = ((String)gotNbt).substring(0, ((String)gotNbt).indexOf("]"));
        gotNbt = ((String)gotNbt).replace("/ ", "");
        gotNbt = "\"" + (String)gotNbt + "\"";
        boolean equalNbt = false;
        equalNbt = mode == 0 ? BetterCopperGolemMixin.nbtComparisonBase((String)handNbt, (String)gotNbt) : BetterCopperGolemMixin.nbtComparisonExtended((String)handNbt, (String)gotNbt);
        return equalNbt && (itemStack.getItem().toString().contains(stack.getItem().toString()) || stack.getItem().toString().contains(itemStack.getItem().toString()));
    }

    private static boolean nbtComparisonBase(String handNbt, String gotNbt) {
        if (handNbt.equals("\"minecraft:water\"") && gotNbt.equals("\"minecraft:water\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:mundane\"") && gotNbt.equals("\"minecraft:mundane\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:thick\"") && gotNbt.equals("\"minecraft:thick\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:awkward\"") && gotNbt.equals("\"minecraft:awkward\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:wind_charged\"") && gotNbt.equals("\"minecraft:wind_charged\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:luck\"") && gotNbt.equals("\"minecraft:luck\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:weaving\"") && gotNbt.equals("\"minecraft:weaving\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:oozing\"") && gotNbt.equals("\"minecraft:oozing\"")) {
            return true;
        }
        if (handNbt.equals("\"minecraft:infested\"") && gotNbt.equals("\"minecraft:infested\"")) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:night_vision\"") || handNbt.equals("\"minecraft:long_night_vision\"")) && (gotNbt.equals("\"minecraft:night_vision\"") || gotNbt.equals("\"minecraft:long_night_vision\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:invisibility\"") || handNbt.equals("\"minecraft:long_invisibility\"")) && (gotNbt.equals("\"minecraft:invisibility\"") || gotNbt.equals("\"minecraft:long_invisibility\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:fire_resistance\"") || handNbt.equals("\"minecraft:long_fire_resistance\"")) && (gotNbt.equals("\"minecraft:fire_resistance\"") || gotNbt.equals("\"minecraft:long_fire_resistance\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:water_breathing\"") || handNbt.equals("\"minecraft:long_water_breathing\"")) && (gotNbt.equals("\"minecraft:water_breathing\"") || gotNbt.equals("\"minecraft:long_water_breathing\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:healing\"") || handNbt.equals("\"minecraft:strong_healing\"")) && (gotNbt.equals("\"minecraft:healing\"") || gotNbt.equals("\"minecraft:strong_healing\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:harming\"") || handNbt.equals("\"minecraft:strong_harming\"")) && (gotNbt.equals("\"minecraft:harming\"") || gotNbt.equals("\"minecraft:strong_harming\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:weakness\"") || handNbt.equals("\"minecraft:long_weakness\"")) && (gotNbt.equals("\"minecraft:weakness\"") || gotNbt.equals("\"minecraft:long_weakness\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:slow_falling\"") || handNbt.equals("\"minecraft:long_slow_falling\"")) && (gotNbt.equals("\"minecraft:slow_falling\"") || gotNbt.equals("\"minecraft:long_slow_falling\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:leaping\"") || handNbt.equals("\"minecraft:strong_leaping\"") || handNbt.equals("\"minecraft:long_leaping\"")) && (gotNbt.equals("\"minecraft:leaping\"") || gotNbt.equals("\"minecraft:strong_leaping\"") || gotNbt.equals("\"minecraft:long_leaping\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:swiftness\"") || handNbt.equals("\"minecraft:strong_swiftness\"") || handNbt.equals("\"minecraft:long_swiftness\"")) && (gotNbt.equals("\"minecraft:swiftness\"") || gotNbt.equals("\"minecraft:strong_swiftness\"") || gotNbt.equals("\"minecraft:long_swiftness\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:slowness\"") || handNbt.equals("\"minecraft:strong_slowness\"") || handNbt.equals("\"minecraft:long_slowness\"")) && (gotNbt.equals("\"minecraft:slowness\"") || gotNbt.equals("\"minecraft:strong_slowness\"") || gotNbt.equals("\"minecraft:long_slowness\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:poison\"") || handNbt.equals("\"minecraft:strong_poison\"") || handNbt.equals("\"minecraft:long_poison\"")) && (gotNbt.equals("\"minecraft:poison\"") || gotNbt.equals("\"minecraft:strong_poison\"") || gotNbt.equals("\"minecraft:long_poison\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:regeneration\"") || handNbt.equals("\"minecraft:strong_regeneration\"") || handNbt.equals("\"minecraft:long_regeneration\"")) && (gotNbt.equals("\"minecraft:regeneration\"") || gotNbt.equals("\"minecraft:strong_regeneration\"") || gotNbt.equals("\"minecraft:long_regeneration\""))) {
            return true;
        }
        if ((handNbt.equals("\"minecraft:strength\"") || handNbt.equals("\"minecraft:strong_strength\"") || handNbt.equals("\"minecraft:long_strength\"")) && (gotNbt.equals("\"minecraft:strength\"") || gotNbt.equals("\"minecraft:strong_strength\"") || gotNbt.equals("\"minecraft:long_strength\""))) {
            return true;
        }
        return !(!handNbt.equals("\"minecraft:turtle_master\"") && !handNbt.equals("\"minecraft:strong_turtle_master\"") && !handNbt.equals("\"minecraft:long_turtle_master\"") || !gotNbt.equals("\"minecraft:turtle_master\"") && !gotNbt.equals("\"minecraft:strong_turtle_master\"") && !gotNbt.equals("\"minecraft:long_turtle_master\""));
    }

    private static boolean nbtComparisonExtended(String handNbt, String gotNbt) {
        return handNbt.equals(gotNbt);
    }
}

