/*
 * Decompiled with CFR 0.152.
 */
package dev.hangel.thefletchingtablemod.event;

import dev.hangel.thefletchingtablemod.screen.FletchingTableBlockMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="the_fletching_table_mod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FletchingTableEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        final BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (level.isClientSide()) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (!state.is(Blocks.FLETCHING_TABLE)) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        serverPlayer.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"block.minecraft.fletching_table");
            }

            public FletchingTableBlockMenu createMenu(int syncId, @NotNull Inventory inv, Player p) {
                return new FletchingTableBlockMenu(syncId, inv, pos);
            }
        }, buf -> buf.writeBlockPos(pos));
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.CONSUME);
        event.setUseBlock(Event.Result.DENY);
        event.setUseItem(Event.Result.DENY);
    }
}

