/*
 * Decompiled with CFR 0.152.
 */
package dev.hangel.thefletchingtablemod.jei;

import dev.hangel.thefletchingtablemod.TheFletchingTableMod;
import dev.hangel.thefletchingtablemod.jei.FletchingTableCategory;
import dev.hangel.thefletchingtablemod.recipe.FletchingTableRecipe;
import dev.hangel.thefletchingtablemod.screen.FletchingTableBlockScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class FletchingTableJEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_fletching_table_mod", (String)"jei_fletching_table");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FletchingTableCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.getInstance().getConnection()).getRecipeManager();
        ArrayList<FletchingTableRecipe> jeiRecipes = new ArrayList<FletchingTableRecipe>();
        List holders = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)TheFletchingTableMod.FLETCHING_TABLE_RECIPE_TYPE.get());
        for (RecipeHolder holder : holders) {
            FletchingTableRecipe base = (FletchingTableRecipe)holder.value();
            Ingredient arrowIng = base.arrowInput();
            Ingredient potionIng = base.potionInput();
            ItemStack[] potionBases = potionIng.getItems();
            boolean allowNormal = Arrays.stream(potionBases).anyMatch(s -> s.is(Items.POTION));
            boolean allowSplash = Arrays.stream(potionBases).anyMatch(s -> s.is(Items.SPLASH_POTION));
            boolean allowLingering = Arrays.stream(potionBases).anyMatch(s -> s.is(Items.LINGERING_POTION));
            if (!(allowNormal || allowSplash || allowLingering)) {
                jeiRecipes.add(base);
                continue;
            }
            for (Potion potion : BuiltInRegistries.POTION) {
                FletchingTableRecipe jeiRecipe;
                ItemStack out;
                ResourceKey key;
                Holder.Reference potionHolder;
                ResourceLocation potionId;
                String path;
                ResourceLocation id = BuiltInRegistries.POTION.getKey((Object)potion);
                if (id != null && ((path = id.getPath()).equals("water") || path.equals("awkward") || path.equals("thick") || path.equals("mundane")) || (potionId = BuiltInRegistries.POTION.getKey((Object)potion)) == null || (potionHolder = (Holder.Reference)BuiltInRegistries.POTION.getHolder(key = ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)potionId)).orElse(null)) == null) continue;
                PotionContents contents = new PotionContents(Optional.of(potionHolder), Optional.empty(), List.of());
                if (allowNormal) {
                    ItemStack normal = new ItemStack((ItemLike)Items.POTION);
                    normal.set(DataComponents.POTION_CONTENTS, (Object)contents);
                    if (!normal.getHoverName().getString().equals(Component.translatable((String)"item.minecraft.potion.effect.empty").getString())) {
                        out = new ItemStack((ItemLike)Items.TIPPED_ARROW);
                        out.set(DataComponents.POTION_CONTENTS, (Object)contents);
                        jeiRecipe = new FletchingTableRecipe(arrowIng, Ingredient.of((ItemStack[])new ItemStack[]{normal}), out);
                        jeiRecipes.add(jeiRecipe);
                    }
                }
                if (allowSplash) {
                    ItemStack splash = new ItemStack((ItemLike)Items.SPLASH_POTION);
                    splash.set(DataComponents.POTION_CONTENTS, (Object)contents);
                    if (!splash.getHoverName().getString().equals(Component.translatable((String)"item.minecraft.splash_potion.effect.empty").getString())) {
                        out = new ItemStack((ItemLike)Items.TIPPED_ARROW);
                        out.set(DataComponents.POTION_CONTENTS, (Object)contents);
                        jeiRecipe = new FletchingTableRecipe(arrowIng, Ingredient.of((ItemStack[])new ItemStack[]{splash}), out);
                        jeiRecipes.add(jeiRecipe);
                    }
                }
                if (!allowLingering) continue;
                ItemStack lingering = new ItemStack((ItemLike)Items.LINGERING_POTION);
                lingering.set(DataComponents.POTION_CONTENTS, (Object)contents);
                if (lingering.getHoverName().getString().equals(Component.translatable((String)"item.minecraft.lingering_potion.effect.empty").getString())) continue;
                out = new ItemStack((ItemLike)Items.TIPPED_ARROW);
                out.set(DataComponents.POTION_CONTENTS, (Object)contents);
                jeiRecipe = new FletchingTableRecipe(arrowIng, Ingredient.of((ItemStack[])new ItemStack[]{lingering}), out);
                jeiRecipes.add(jeiRecipe);
            }
        }
        registration.addRecipes(FletchingTableCategory.FLETCHING_TABLE_RECIPE_TYPE, jeiRecipes);
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(FletchingTableBlockScreen.class, 100, 34, 25, 20, new RecipeType[]{FletchingTableCategory.FLETCHING_TABLE_RECIPE_TYPE});
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FLETCHING_TABLE.asItem()), new RecipeType[]{FletchingTableCategory.FLETCHING_TABLE_RECIPE_TYPE});
    }
}

