/*
 * Decompiled with CFR 0.152.
 */
package dev.hangel.thefletchingtablemod.screen;

import dev.hangel.thefletchingtablemod.TheFletchingTableMod;
import dev.hangel.thefletchingtablemod.recipe.FletchingTableRecipe;
import dev.hangel.thefletchingtablemod.recipe.FletchingTableRecipeInput;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class FletchingTableBlockMenu
extends AbstractContainerMenu {
    private final SimpleContainer inventory;
    private static final int ARROW_SLOT = 0;
    private static final int POTION_SLOT = 1;
    private static final int TIPPED_ARROW_SLOT = 2;
    private final BlockPos pos;
    private final Player opener;
    private boolean suppressCraft;

    public FletchingTableBlockMenu(int syncId, Inventory inv, FriendlyByteBuf buf) {
        this(syncId, inv, buf.readBlockPos());
    }

    public FletchingTableBlockMenu(int syncId, Inventory inv, BlockPos pos) {
        super((MenuType)TheFletchingTableMod.FLETCHING_TABLE_MENU.get(), syncId);
        this.pos = pos;
        this.opener = inv.player;
        this.inventory = new SimpleContainer(3){

            public void setChanged() {
                super.setChanged();
                if (!FletchingTableBlockMenu.this.suppressCraft) {
                    FletchingTableBlockMenu.this.craftLogic();
                }
            }
        };
        this.addSlot(new Slot((Container)this.inventory, 0, 25, 34){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return FletchingTableBlockMenu.this.isArrowInput(stack);
            }
        });
        this.addSlot(new Slot((Container)this.inventory, 1, 78, 34){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return FletchingTableBlockMenu.this.isPotionInput(stack);
            }
        });
        this.addSlot(new Slot((Container)this.inventory, 2, 132, 34){

            public boolean mayPlace(@NotNull ItemStack p_40231_) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                super.onTake(player, stack);
                int toConsume = stack.getCount();
                ItemStack arrows = FletchingTableBlockMenu.this.inventory.getItem(0);
                ItemStack potion = FletchingTableBlockMenu.this.inventory.getItem(1);
                arrows.shrink(Math.min(toConsume, arrows.getCount()));
                if (!potion.isEmpty()) {
                    potion.shrink(1);
                }
            }
        });
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
    }

    private boolean isArrowInput(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (RecipeHolder entry : this.opener.level().getRecipeManager().getAllRecipesFor((RecipeType)TheFletchingTableMod.FLETCHING_TABLE_RECIPE_TYPE.get())) {
            if (!((FletchingTableRecipe)entry.value()).arrowInput().test(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isPotionInput(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (RecipeHolder entry : this.opener.level().getRecipeManager().getAllRecipesFor((RecipeType)TheFletchingTableMod.FLETCHING_TABLE_RECIPE_TYPE.get())) {
            if (!((FletchingTableRecipe)entry.value()).potionInput().test(stack)) continue;
            return true;
        }
        return false;
    }

    private void craftLogic() {
        if (this.hasRecipe()) {
            this.showTippedArrows();
        } else {
            this.removeTippedArrows();
        }
    }

    private void showTippedArrows() {
        Optional<RecipeHolder<FletchingTableRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        int count = this.inventory.getItem(0).getCount();
        ItemStack tippedArrowsStack = ((FletchingTableRecipe)recipe.get().value()).output();
        tippedArrowsStack.setCount(count);
        ItemStack potionStack = this.inventory.getItem(1);
        PotionContents potionContents = (PotionContents)potionStack.get(DataComponents.POTION_CONTENTS);
        if (potionContents != null) {
            tippedArrowsStack.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        }
        this.suppressCraft = true;
        this.inventory.setItem(2, tippedArrowsStack);
        this.suppressCraft = false;
    }

    private void removeTippedArrows() {
        this.suppressCraft = true;
        this.inventory.setItem(2, ItemStack.EMPTY);
        this.suppressCraft = false;
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<FletchingTableRecipe>> recipe = this.getCurrentRecipe();
        return recipe.isPresent();
    }

    private Optional<RecipeHolder<FletchingTableRecipe>> getCurrentRecipe() {
        return this.opener.level().getRecipeManager().getRecipeFor((RecipeType)TheFletchingTableMod.FLETCHING_TABLE_RECIPE_TYPE.get(), (RecipeInput)new FletchingTableRecipeInput(this.inventory.getItem(0), this.inventory.getItem(1)), this.opener.level());
    }

    public void removed(Player player) {
        super.removed(player);
        if (player.level().isClientSide()) {
            return;
        }
        for (int slot = 0; slot < 2; ++slot) {
            ItemStack stack = this.inventory.getItem(slot);
            if (stack.isEmpty()) continue;
            ItemStack toGive = stack.copy();
            this.inventory.setItem(slot, ItemStack.EMPTY);
            player.getInventory().placeItemBackInInventory(toGive);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        int containerSlots;
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack original = slot.getItem();
        newStack = original.copy();
        int playerStart = containerSlots = 3;
        int hotbarEnd = playerStart + 27 + 9;
        if (index < containerSlots) {
            if (!this.moveItemStackTo(original, playerStart, hotbarEnd, true)) {
                return ItemStack.EMPTY;
            }
            if (index == 2) {
                slot.onTake(player, newStack);
            }
        } else if (!this.moveItemStackTo(original, 0, containerSlots, false)) {
            return ItemStack.EMPTY;
        }
        if (original.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return this.opener.blockPosition().closerThan((Vec3i)this.pos, 8.0);
    }
}

