/*
 * Decompiled with CFR 0.152.
 */
package dev.hangel.thefletchingtablemod.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.hangel.thefletchingtablemod.screen.FletchingTableBlockMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class FletchingTableBlockScreen
extends AbstractContainerScreen<FletchingTableBlockMenu> {
    public static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_fletching_table_mod", (String)"textures/gui/fletching_table_gui.png");

    public FletchingTableBlockScreen(FletchingTableBlockMenu handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        Minecraft client = Minecraft.getInstance();
        TextureAtlas atlas = client.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
        context.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        TextureAtlasSprite arrowSprite = atlas.getSprite(ResourceLocation.parse((String)"item/arrow"));
        TextureAtlasSprite potionSprite = atlas.getSprite(ResourceLocation.parse((String)"item/potion"));
        TextureAtlasSprite splashPotionSprite = atlas.getSprite(ResourceLocation.parse((String)"item/splash_potion"));
        TextureAtlasSprite lingeringPotionSprite = atlas.getSprite(ResourceLocation.parse((String)"item/lingering_potion"));
        TextureAtlasSprite tippedArrowSpriteBase = atlas.getSprite(ResourceLocation.parse((String)"item/tipped_arrow_base"));
        TextureAtlasSprite tippedArrowSpriteHead = atlas.getSprite(ResourceLocation.parse((String)"item/tipped_arrow_head"));
        if (((FletchingTableBlockMenu)this.menu).getSlot(0).getItem().isEmpty()) {
            context.blit(x + 25, y + 34, 0, 16, 16, arrowSprite);
        }
        long time = client.level != null ? client.level.getGameTime() : 0L;
        int periodTicks = 20;
        int index = (int)(time / (long)periodTicks % 3L);
        TextureAtlasSprite current = switch (index) {
            case 0 -> potionSprite;
            case 1 -> splashPotionSprite;
            default -> lingeringPotionSprite;
        };
        if (((FletchingTableBlockMenu)this.menu).getSlot(1).getItem().isEmpty()) {
            context.blit(x + 78, y + 34, 0, 16, 16, current);
        }
        if (((FletchingTableBlockMenu)this.menu).getSlot(2).getItem().isEmpty()) {
            context.blit(x + 132, y + 34, 0, 16, 16, tippedArrowSpriteBase);
            context.blit(x + 132, y + 34, 0, 16, 16, tippedArrowSpriteHead);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }
}

