/*
 * Decompiled with CFR 0.152.
 */
package dev.hangel.thefletchingtablemod.rei;

import dev.hangel.thefletchingtablemod.rei.FletchingTableDisplay;
import dev.hangel.thefletchingtablemod.screen.FletchingTableBlockScreenHandler;
import java.util.List;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class FletchingTableTransferHandler
implements TransferHandler {
    private static final int ARROW_SLOT = 0;
    private static final int POTION_SLOT = 1;
    private static final int CONTAINER_SLOT_COUNT = 3;

    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (!(context.getMenu() instanceof FletchingTableBlockScreenHandler)) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        if (!(context.getDisplay() instanceof FletchingTableDisplay)) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    public TransferHandler.Result handle(TransferHandler.Context context) {
        class_1703 class_17032 = context.getMenu();
        if (!(class_17032 instanceof FletchingTableBlockScreenHandler)) {
            return TransferHandler.Result.createNotApplicable();
        }
        FletchingTableBlockScreenHandler handler = (FletchingTableBlockScreenHandler)class_17032;
        Display display = context.getDisplay();
        if (!(display instanceof FletchingTableDisplay)) {
            return TransferHandler.Result.createNotApplicable();
        }
        FletchingTableDisplay display2 = (FletchingTableDisplay)display;
        class_310 mc = context.getMinecraft();
        class_746 player = mc.field_1724;
        if (player == null || mc.field_1761 == null) {
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_30163((String)"err"));
        }
        List inputs = display2.getInputEntries();
        if (inputs.size() < 2) {
            return TransferHandler.Result.createNotApplicable();
        }
        class_1799 arrowTemplate = this.getFirstItemStack((EntryIngredient)inputs.get(0));
        class_1799 potionTemplate = this.getFirstItemStack((EntryIngredient)inputs.get(1));
        if (arrowTemplate.method_7960() || potionTemplate.method_7960()) {
            return TransferHandler.Result.createNotApplicable();
        }
        boolean canTransfer = this.canPerformTransfer(handler, arrowTemplate, potionTemplate);
        if (!context.isActuallyCrafting()) {
            if (!canTransfer) {
                return TransferHandler.Result.createFailed((class_2561)class_2561.method_30163((String)"Not enough items"));
            }
            return TransferHandler.Result.createSuccessful();
        }
        if (!canTransfer) {
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_30163((String)"Not enough items"));
        }
        this.clearSlotToPlayerInventory(handler, (class_1657)player, 0);
        this.clearSlotToPlayerInventory(handler, (class_1657)player, 1);
        boolean okArrow = this.moveOneStackLike(handler, (class_1657)player, arrowTemplate, 0);
        boolean okPotion = this.moveOneStackLike(handler, (class_1657)player, potionTemplate, 1);
        if (!okArrow || !okPotion) {
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_30163((String)"err"));
        }
        return TransferHandler.Result.createSuccessful().blocksFurtherHandling(true);
    }

    private boolean canPerformTransfer(class_1703 handler, class_1799 arrowTemplate, class_1799 potionTemplate) {
        boolean hasArrow = false;
        boolean hasPotion = false;
        class_2371 slots = handler.field_7761;
        for (int i = 3; i < slots.size(); ++i) {
            class_1799 stack = ((class_1735)slots.get(i)).method_7677();
            if (stack.method_7960()) continue;
            if (!hasArrow && class_1799.method_31577((class_1799)stack, (class_1799)arrowTemplate)) {
                hasArrow = true;
            }
            if (!hasPotion && class_1799.method_31577((class_1799)stack, (class_1799)potionTemplate)) {
                hasPotion = true;
            }
            if (!hasArrow || !hasPotion) continue;
            return true;
        }
        return false;
    }

    private class_1799 getFirstItemStack(EntryIngredient ingredient) {
        if (ingredient.isEmpty()) {
            return class_1799.field_8037;
        }
        EntryStack entry = (EntryStack)ingredient.get(0);
        Object object = entry.getValue();
        if (object instanceof class_1799) {
            class_1799 stack = (class_1799)object;
            return stack.method_7972();
        }
        return class_1799.field_8037;
    }

    private void clearSlotToPlayerInventory(class_1703 handler, class_1657 player, int slotIndex) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1761 == null) {
            return;
        }
        class_1735 slot = (class_1735)handler.field_7761.get(slotIndex);
        if (!slot.method_7681()) {
            return;
        }
        int syncId = handler.field_7763;
        mc.field_1761.method_2906(syncId, slotIndex, 0, class_1713.field_7790, player);
        int firstPlayerSlot = 3;
        int lastSlot = handler.field_7761.size();
        for (int i = firstPlayerSlot; i < lastSlot; ++i) {
            if (((class_1735)handler.field_7761.get(i)).method_7681()) continue;
            mc.field_1761.method_2906(syncId, i, 0, class_1713.field_7790, player);
            return;
        }
        mc.field_1761.method_2906(syncId, slotIndex, 0, class_1713.field_7790, player);
    }

    private boolean moveOneStackLike(class_1703 handler, class_1657 player, class_1799 template, int targetSlotIndex) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1761 == null) {
            return false;
        }
        int syncId = handler.field_7763;
        class_2371 slots = handler.field_7761;
        int firstPlayerSlot = 3;
        int sourceSlot = -1;
        for (int i = firstPlayerSlot; i < slots.size(); ++i) {
            class_1799 stack = ((class_1735)slots.get(i)).method_7677();
            if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)template)) continue;
            sourceSlot = i;
            break;
        }
        if (sourceSlot == -1) {
            return false;
        }
        mc.field_1761.method_2906(syncId, sourceSlot, 0, class_1713.field_7790, player);
        mc.field_1761.method_2906(syncId, targetSlotIndex, 0, class_1713.field_7790, player);
        mc.field_1761.method_2906(syncId, sourceSlot, 0, class_1713.field_7790, player);
        return true;
    }
}

