/*
 * Decompiled with CFR 0.152.
 */
package dev.hangel.thefletchingtablemod.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hangel.thefletchingtablemod.TheFletchingTableMod;
import dev.hangel.thefletchingtablemod.recipe.FletchingTableRecipeInput;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FletchingTableRecipe(Ingredient arrowInput, Ingredient potionInput, ItemStack output) implements Recipe<FletchingTableRecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.arrowInput);
        list.add((Object)this.potionInput);
        return list;
    }

    public boolean matches(FletchingTableRecipeInput input, @NotNull Level level) {
        return this.arrowInput.test(input.getItem(0)) && this.potionInput.test(input.getItem(1));
    }

    @NotNull
    public ItemStack assemble(@NotNull FletchingTableRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HolderLookup.Provider registriesLookup) {
        return this.output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TheFletchingTableMod.FLETCHING_TABLE_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)TheFletchingTableMod.FLETCHING_TABLE_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<FletchingTableRecipe> {
        public static final MapCodec<FletchingTableRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("arrow").forGetter(FletchingTableRecipe::arrowInput), (App)Ingredient.CODEC.fieldOf("potion").forGetter(FletchingTableRecipe::potionInput), (App)ItemStack.CODEC.fieldOf("result").forGetter(FletchingTableRecipe::output)).apply((Applicative)inst, FletchingTableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FletchingTableRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FletchingTableRecipe::arrowInput, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FletchingTableRecipe::potionInput, (StreamCodec)ItemStack.STREAM_CODEC, FletchingTableRecipe::output, FletchingTableRecipe::new);

        @NotNull
        public MapCodec<FletchingTableRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FletchingTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

