/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.content.block;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u0000 }2\u00020\u0001:\u0001}B\u0083\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\u0012\b\u0002\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010 \u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b \u0010\u001cJ'\u0010$\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b$\u0010%J#\u0010)\u001a\u00020(2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150&H\u0014\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010,\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b.\u0010/J'\u00103\u001a\u0002022\u0006\u00101\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b3\u00104J\u001f\u00106\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b8\u00109J\u001d\u0010;\u001a\u00020\u00152\u0006\u0010:\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b;\u0010<J\u001f\u0010>\u001a\u00020=2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b>\u0010?J/\u0010C\u001a\u00020B2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010:\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010A\u001a\u00020@H\u0016\u00a2\u0006\u0004\bC\u0010DJ\u0019\u0010G\u001a\u0004\u0018\u00010\u00152\u0006\u0010F\u001a\u00020EH\u0016\u00a2\u0006\u0004\bG\u0010HJ'\u0010J\u001a\u00020(2\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\bJ\u0010KJ\u001f\u0010L\u001a\u00020(2\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010N\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\bN\u0010OJ/\u0010Q\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\bQ\u0010RJ7\u0010T\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010S\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\bT\u0010UJ/\u0010X\u001a\u00020(2\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00152\u0006\u0010W\u001a\u00020VH\u0016\u00a2\u0006\u0004\bX\u0010YJ1\u0010Z\u001a\u00020(2\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00152\b\u0010W\u001a\u0004\u0018\u00010VH\u0004\u00a2\u0006\u0004\bZ\u0010YJ/\u0010^\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010[\u001a\u00020+2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010]\u001a\u00020\\H\u0016\u00a2\u0006\u0004\b^\u0010_J9\u0010c\u001a\u00020(2\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00152\b\u0010a\u001a\u0004\u0018\u00010`2\u0006\u0010b\u001a\u000202H\u0016\u00a2\u0006\u0004\bc\u0010dJ1\u0010f\u001a\u00020(2\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u00152\b\b\u0002\u0010e\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\bf\u0010gJ?\u0010m\u001a\u00020l2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010:\u001a\u00020I2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010W\u001a\u00020V2\u0006\u0010i\u001a\u00020h2\u0006\u0010k\u001a\u00020jH\u0016\u00a2\u0006\u0004\bm\u0010nR$\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00068\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\b\u0010o\u001a\u0004\bp\u0010qR\u001a\u0010\u0010\u001a\u00020\u000f8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010r\u001a\u0004\bs\u0010tR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00068\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010o\u001a\u0004\bu\u0010qR$\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00068\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\n\u0010o\u001a\u0004\bv\u0010qR\u001a\u0010\f\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\f\u0010w\u001a\u0004\bx\u0010yR\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010w\u001a\u0004\b\u0005\u0010yR\u001a\u0010\u000b\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010w\u001a\u0004\b\u000b\u0010yR\u001a\u0010\t\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\t\u0010w\u001a\u0004\b\t\u0010yR\u001a\u0010\u0012\u001a\u00020\u00118\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010z\u001a\u0004\b{\u0010|\u00a8\u0006~"}, d2={"Lcom/dannbrown/deltaboxlib/content/block/GenericCropBlock;", "Lnet/minecraft/world/level/block/CropBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "props", "", "isBudding", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/level/block/Block;", "buddingBlock", "isDouble", "grownBlock", "isBush", "includeSeedOnDrop", "Lnet/minecraft/world/level/ItemLike;", "fruitItem", "", "chance", "", "multiplier", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;ZLjava/util/function/Supplier;ZLjava/util/function/Supplier;ZZLjava/util/function/Supplier;FI)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/LevelReader;", "worldIn", "Lnet/minecraft/core/BlockPos;", "pos", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "pState", "pLevel", "pPos", "canSurviveDouble", "levelReader", "blockPos", "blockState", "copyWaterloggedFrom", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/server/level/ServerLevel;", "dropResources", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V", "getBaseSeedId", "()Lnet/minecraft/world/level/ItemLike;", "Lnet/minecraft/world/level/BlockGetter;", "arg", "Lnet/minecraft/world/item/ItemStack;", "getCloneItemStack", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "blockstate", "getDoubleOtherPos", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/core/BlockPos;", "getOtherBlockstate", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/state/BlockState;", "level", "getPlant", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "", "getSeed", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)J", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "blockPlaceContext", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "growCrops", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "growTall", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "isRandomlyTicking", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "bl", "isValidBonemealTarget", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)Z", "blockState2", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/entity/player/Player;", "player", "playerWillDestroy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)V", "preventCreativeDropFromBottomPart", "serverLevel", "Lnet/minecraft/util/RandomSource;", "randomSource", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/entity/LivingEntity;", "livingEntity", "itemStack", "setPlacedBy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "i", "updateBlockState", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)V", "Lnet/minecraft/world/InteractionHand;", "interactionHand", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Ljava/util/function/Supplier;", "getBuddingBlock", "()Ljava/util/function/Supplier;", "F", "getChance", "()F", "getFruitItem", "getGrownBlock", "Z", "getIncludeSeedOnDrop", "()Z", "I", "getMultiplier", "()I", "Companion", "deltaboxlib-2.1.1-common-1.20.1"})
public class GenericCropBlock
extends CropBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isBudding;
    @Nullable
    private final Supplier<? extends Block> buddingBlock;
    private final boolean isDouble;
    @Nullable
    private final Supplier<? extends Block> grownBlock;
    private final boolean isBush;
    private final boolean includeSeedOnDrop;
    @Nullable
    private final Supplier<ItemLike> fruitItem;
    private final float chance;
    private final int multiplier;
    @NotNull
    private static final VoxelShape[] SHAPE_BY_AGE;
    private static final EnumProperty<DoubleBlockHalf> HALF;
    private static final int MID_STAGE;

    public GenericCropBlock(@NotNull BlockBehaviour.Properties props, boolean isBudding, @Nullable Supplier<? extends Block> buddingBlock, boolean isDouble, @Nullable Supplier<? extends Block> grownBlock, boolean isBush, boolean includeSeedOnDrop, @Nullable Supplier<ItemLike> fruitItem, float chance, int multiplier) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        super(props);
        this.isBudding = isBudding;
        this.buddingBlock = buddingBlock;
        this.isDouble = isDouble;
        this.grownBlock = grownBlock;
        this.isBush = isBush;
        this.includeSeedOnDrop = includeSeedOnDrop;
        this.fruitItem = fruitItem;
        this.chance = chance;
        this.multiplier = multiplier;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(0)));
    }

    public /* synthetic */ GenericCropBlock(BlockBehaviour.Properties properties, boolean bl, Supplier supplier, boolean bl2, Supplier supplier2, boolean bl3, boolean bl4, Supplier supplier3, float f, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            supplier = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            supplier2 = null;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x100) != 0) {
            f = 1.0f;
        }
        if ((n2 & 0x200) != 0) {
            n = 1;
        }
        this(properties, bl, supplier, bl2, supplier2, bl3, bl4, supplier3, f, n);
    }

    protected final boolean isBudding() {
        return this.isBudding;
    }

    @Nullable
    protected final Supplier<? extends Block> getBuddingBlock() {
        return this.buddingBlock;
    }

    protected final boolean isDouble() {
        return this.isDouble;
    }

    @Nullable
    protected final Supplier<? extends Block> getGrownBlock() {
        return this.grownBlock;
    }

    protected final boolean isBush() {
        return this.isBush;
    }

    protected final boolean getIncludeSeedOnDrop() {
        return this.includeSeedOnDrop;
    }

    @Nullable
    protected final Supplier<ItemLike> getFruitItem() {
        return this.fruitItem;
    }

    protected final float getChance() {
        return this.chance;
    }

    protected final int getMultiplier() {
        return this.multiplier;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HALF, CropBlock.f_52244_};
        builder.m_61104_(propertyArray);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        return blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_60629_(blockPlaceContext) ? super.m_5573_(blockPlaceContext) : null;
    }

    @NotNull
    protected ItemLike m_6404_() {
        ItemLike itemLike;
        if (this.fruitItem != null) {
            ItemLike itemLike2 = this.fruitItem.get();
            Intrinsics.checkNotNullExpressionValue((Object)itemLike2, (String)"get(...)");
            itemLike = itemLike2;
        } else {
            Item item = this.m_5456_();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"asItem(...)");
            itemLike = (ItemLike)item;
        }
        return itemLike;
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter arg, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ItemStack(this.fruitItem != null ? this.fruitItem.get() : (ItemLike)this.m_5456_());
    }

    @NotNull
    public final BlockState getPlant(@NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState blockState = this.m_49966_();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        return blockState;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isDouble) {
            VoxelShape voxelShape2;
            if (state.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER) {
                voxelShape2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            } else {
                Comparable comparable = state.m_61143_((Property)this.m_7959_());
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
                voxelShape2 = SHAPE_BY_AGE[((Number)((Object)comparable)).intValue()];
            }
            VoxelShape voxelShape3 = voxelShape2;
            Intrinsics.checkNotNull((Object)voxelShape3);
            voxelShape = voxelShape3;
        } else {
            Comparable comparable = state.m_61143_((Property)this.m_7959_());
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            voxelShape = SHAPE_BY_AGE[((Number)((Object)comparable)).intValue()];
        }
        return voxelShape;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        boolean isMaxAge;
        Integer age;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        Integer n = age = (Integer)blockState.m_61143_((Property)this.m_7959_());
        int n2 = this.m_7419_();
        boolean bl = isMaxAge = n != null && n == n2;
        if (!isMaxAge && player.m_21120_(interactionHand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (isMaxAge && !level.f_46443_ && this.isBush) {
            this.dropResources((ServerLevel)level, blockPos);
            Object object = blockState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(MID_STAGE));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            this.updateBlockState(level, blockPos, (BlockState)object, 2);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"use(...)");
        return interactionResult;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @Nullable LivingEntity livingEntity, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (this.isDouble) {
            BlockPos blockPos2 = blockPos.m_7494_();
            BlockState blockAbove = level.m_8055_(blockPos2);
            if ((blockAbove.m_60795_() || blockAbove.m_60713_(Blocks.f_49990_)) && !blockAbove.m_280296_()) {
                LevelReader levelReader = (LevelReader)level;
                Intrinsics.checkNotNull((Object)blockPos2);
                Object object = this.m_49966_().m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.UPPER);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
                level.m_7731_(blockPos2, this.copyWaterloggedFrom(levelReader, blockPos2, (BlockState)object), 3);
            }
        } else {
            super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        }
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.isDouble) {
            return (worldIn.m_45524_(pos, 0) >= 8 || worldIn.m_45527_(pos)) && this.canSurviveDouble(state, worldIn, pos);
        }
        return super.m_7898_(state, worldIn, pos);
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.isDouble && !level.f_46443_) {
            BlockPos otherPos;
            BlockState otherState;
            if (player.m_7500_()) {
                this.preventCreativeDropFromBottomPart(level, blockPos, blockState, player);
            } else {
                CropBlock.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, null, (Entity)((Entity)player), (ItemStack)player.m_21205_());
            }
            if (this.buddingBlock != null && blockState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER && ((otherState = level.m_8055_(otherPos = this.getDoubleOtherPos(blockPos, blockState))).m_60795_() || otherState.m_60713_((Block)this) && otherState.m_61143_((Property)HALF) != blockState.m_61143_((Property)HALF))) {
                level.m_7731_(otherPos, (BlockState)this.buddingBlock.get().m_49966_().m_61124_((Property)HALF, this.getOtherBlockstate(blockState).m_61143_((Property)HALF)), 3);
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6807_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState2, boolean bl) {
        BlockPos blockPos2;
        BlockState blockAbove;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState2, (String)"blockState2");
        if (this.isDouble && blockState.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER && ((blockAbove = level.m_8055_(blockPos2 = blockPos.m_7494_())).m_60795_() || blockAbove.m_60713_(Blocks.f_49990_)) && blockAbove.m_247087_()) {
            LevelReader levelReader = (LevelReader)level;
            Intrinsics.checkNotNull((Object)blockPos2);
            Object object = this.m_49966_().m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.UPPER);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            level.m_7731_(blockPos2, this.copyWaterloggedFrom(levelReader, blockPos2, (BlockState)object), 3);
        }
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
    }

    public long m_7799_(@NotNull BlockState blockState, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (this.isDouble) {
            return Mth.m_14130_((int)blockPos.m_123341_(), (int)blockPos.m_6625_(blockState.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)blockPos.m_123343_());
        }
        return super.m_7799_(blockState, blockPos);
    }

    protected boolean canSurviveDouble(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        if (pState.m_61143_((Property)HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        BlockState blockState2 = pLevel.m_8055_(pPos.m_7495_());
        return blockState2.m_60713_((Block)this) && blockState2.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public void m_52263_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        int newState = this.m_52305_(blockState) + this.m_7125_(level);
        if (newState > this.m_7419_()) {
            newState = this.m_7419_();
        }
        if (blockState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            BlockPos lowerPos = blockPos.m_7495_();
            BlockState lowerState = level.m_8055_(lowerPos);
            if (lowerState.m_60713_((Block)this) && lowerState.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER) {
                Intrinsics.checkNotNull((Object)lowerPos);
                BlockState blockState2 = this.m_52289_(newState);
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getStateForAge(...)");
                this.updateBlockState(level, lowerPos, blockState2, 2);
            }
        } else if (newState == this.m_7419_() && this.isBudding && !this.isDouble) {
            this.growTall(level, blockPos);
        } else {
            BlockState blockState3 = this.m_52289_(newState);
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"getStateForAge(...)");
            this.updateBlockState(level, blockPos, blockState3, 2);
        }
    }

    public boolean m_6724_(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return this.isBudding ? true : super.m_6724_(blockState);
    }

    public void m_213898_(@NotNull BlockState blockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)randomSource, (String)"randomSource");
        if (blockState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (serverLevel.m_45524_(blockPos, 0) >= 9) {
            float f;
            int i = this.m_52305_(blockState);
            if (i == this.m_7419_() && this.isBudding) {
                this.growTall((Level)serverLevel, blockPos);
                return;
            }
            if (i < this.m_7419_() && randomSource.m_188503_((int)(25.0f / (f = CropBlock.m_52272_((Block)((Block)this), (BlockGetter)((BlockGetter)serverLevel), (BlockPos)blockPos))) + 1) == 0) {
                Level level = (Level)serverLevel;
                BlockState blockState2 = this.m_52289_(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getStateForAge(...)");
                this.updateBlockState(level, blockPos, blockState2, 2);
            }
        }
    }

    public boolean m_7370_(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)levelReader, (String)"levelReader");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return this.isBudding ? true : super.m_7370_(levelReader, blockPos, blockState, bl);
    }

    protected void updateBlockState(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockstate, int i) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockstate, (String)"blockstate");
        level.m_7731_(blockPos, blockstate, i);
        if (this.isDouble) {
            level.m_7731_(this.getDoubleOtherPos(blockPos, blockstate), this.getOtherBlockstate(blockstate), i);
        }
    }

    public static /* synthetic */ void updateBlockState$default(GenericCropBlock genericCropBlock, Level level, BlockPos blockPos, BlockState blockState, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateBlockState");
        }
        if ((n2 & 8) != 0) {
            n = 3;
        }
        genericCropBlock.updateBlockState(level, blockPos, blockState, n);
    }

    protected void growTall(@NotNull Level level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (!this.isBudding || this.grownBlock == null || !level.m_8055_(blockPos.m_7494_()).m_247087_()) {
            return;
        }
        BlockPos abovePos = blockPos.m_7494_();
        level.m_7731_(blockPos, (BlockState)this.grownBlock.get().m_49966_().m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
        level.m_7731_(abovePos, (BlockState)this.grownBlock.get().m_49966_().m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @NotNull
    protected BlockPos getDoubleOtherPos(@NotNull BlockPos blockPos, @NotNull BlockState blockstate) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockstate, (String)"blockstate");
        if (blockstate.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER) {
            BlockPos blockPos2 = blockPos.m_7494_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"above(...)");
            return blockPos2;
        }
        if (blockstate.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockPos3 = blockPos.m_7495_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"below(...)");
            return blockPos3;
        }
        return blockPos;
    }

    @NotNull
    protected BlockState getOtherBlockstate(@NotNull BlockState blockstate) {
        Intrinsics.checkNotNullParameter((Object)blockstate, (String)"blockstate");
        if (blockstate.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER) {
            Object object = blockstate.m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.UPPER);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }
        if (blockstate.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            Object object = blockstate.m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }
        return blockstate;
    }

    protected void dropResources(@NotNull ServerLevel pLevel, @NotNull BlockPos pPos) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        if (!this.isBush) {
            return;
        }
        int seedsToDrop = 0;
        int n = this.multiplier;
        for (int i = 0; i < n; ++i) {
            if (!(pLevel.f_46441_.m_188501_() < this.chance)) continue;
            ++seedsToDrop;
        }
        if (seedsToDrop > 0 && this.includeSeedOnDrop) {
            Block.m_49840_((Level)((Level)pLevel), (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this.m_5456_(), seedsToDrop));
        }
        if (this.fruitItem != null) {
            int dropsToDrop = 1;
            int n2 = this.multiplier - 1;
            for (int i = 0; i < n2; ++i) {
                if (!(pLevel.f_46441_.m_188501_() < this.chance)) continue;
                ++dropsToDrop;
            }
            if (dropsToDrop > 0) {
                Block.m_49840_((Level)((Level)pLevel), (BlockPos)pPos, (ItemStack)new ItemStack(this.fruitItem.get(), dropsToDrop));
            }
        }
        pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
    }

    protected final void preventCreativeDropFromBottomPart(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @Nullable Player player) {
        BlockPos belowPos;
        BlockState belowState;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_((Property)HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (belowState = level.m_8055_(belowPos = blockPos.m_7495_())).m_60713_((Block)this) && belowState.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState3 = belowState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(belowPos, blockState3, 35);
            level.m_5898_(player, 2001, belowPos, CropBlock.m_49956_((BlockState)belowState));
        }
    }

    @NotNull
    protected BlockState copyWaterloggedFrom(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        BlockState blockState2;
        Intrinsics.checkNotNullParameter((Object)levelReader, (String)"levelReader");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            Object object = blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelReader.m_46801_(blockPos)));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            blockState2 = (BlockState)object;
        } else {
            blockState2 = blockState;
        }
        return blockState2;
    }

    static {
        VoxelShape[] voxelShapeArray = new VoxelShape[8];
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (String)"box(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (String)"box(...)");
        SHAPE_BY_AGE = voxelShapeArray;
        HALF = BlockStateProperties.f_61401_;
        MID_STAGE = 3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u000b8\u0004X\u0084D\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/dannbrown/deltaboxlib/content/block/GenericCropBlock$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/DoubleBlockHalf;", "kotlin.jvm.PlatformType", "HALF", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "getHALF", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "", "MID_STAGE", "I", "getMID_STAGE", "()I", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE_BY_AGE", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE_BY_AGE", "()[Lnet/minecraft/world/phys/shapes/VoxelShape;", "deltaboxlib-2.1.1-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final VoxelShape[] getSHAPE_BY_AGE() {
            return SHAPE_BY_AGE;
        }

        public final EnumProperty<DoubleBlockHalf> getHALF() {
            return HALF;
        }

        protected final int getMID_STAGE() {
            return MID_STAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

