/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.registrate.registry;

import com.dannbrown.deltaboxlib.registrate.builders.BlockBuilder;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJC\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\f\"\b\b\u0000\u0010\n*\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011R8\u0010\u0014\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R%\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000e0\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/BlockRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "", "build", "()V", "Lnet/minecraft/world/level/block/Block;", "T", "id", "Ljava/util/function/Supplier;", "blockSupplier", "Lcom/dannbrown/deltaboxlib/registrate/builders/BlockBuilder;", "blockBuilder", "register", "(Ljava/lang/String;Ljava/util/function/Supplier;Lcom/dannbrown/deltaboxlib/registrate/builders/BlockBuilder;)Ljava/util/function/Supplier;", "Ldev/architectury/registry/registries/DeferredRegister;", "kotlin.jvm.PlatformType", "blocks", "Ldev/architectury/registry/registries/DeferredRegister;", "", "entries", "Ljava/util/List;", "getEntries", "()Ljava/util/List;", "", "isRegistered", "Z", "()Z", "setRegistered", "(Z)V", "deltaboxlib-2.1.1-common-1.20.1"})
public final class BlockRegistry {
    private final DeferredRegister<Block> blocks;
    @NotNull
    private final List<BlockBuilder<? extends Block>> entries;
    private boolean isRegistered;

    public BlockRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.blocks = DeferredRegister.create((String)modId, (ResourceKey)Registries.f_256747_);
        this.entries = new ArrayList();
    }

    @NotNull
    public final List<BlockBuilder<? extends Block>> getEntries() {
        return this.entries;
    }

    public final boolean isRegistered() {
        return this.isRegistered;
    }

    public final void setRegistered(boolean bl) {
        this.isRegistered = bl;
    }

    @NotNull
    public final <T extends Block> Supplier<T> register(@NotNull String id, @NotNull Supplier<T> blockSupplier, @NotNull BlockBuilder<? extends Block> blockBuilder) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(blockSupplier, (String)"blockSupplier");
        Intrinsics.checkNotNullParameter(blockBuilder, (String)"blockBuilder");
        this.entries.add(blockBuilder);
        RegistrySupplier registrySupplier = this.blocks.register(id, blockSupplier);
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier, (String)"register(...)");
        return (Supplier)registrySupplier;
    }

    public final void build() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        this.blocks.register();
    }
}

