/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.registrate.registry;

import dev.architectury.platform.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0006&'()*+B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\bJ-\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001b\u0010\bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010!R$\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006,"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "", "clear", "()V", "createConfigFile", "freeze", "loadConfig", "key", "", "defaultValue", "comment", "Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigSupplier;", "registerBoolean", "(Ljava/lang/String;ZLjava/lang/String;)Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigSupplier;", "", "registerFloat", "(Ljava/lang/String;FLjava/lang/String;)Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigSupplier;", "", "registerInt", "(Ljava/lang/String;ILjava/lang/String;)Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigSupplier;", "registerString", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigSupplier;", "saveConfig", "Ljava/io/File;", "configFile", "Ljava/io/File;", "frozen", "Z", "Ljava/lang/String;", "", "Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigProperty;", "properties", "Ljava/util/Map;", "BooleanConfigProperty", "ConfigProperty", "ConfigSupplier", "FloatConfigProperty", "IntConfigProperty", "StringConfigProperty", "deltaboxlib-2.1.1-common-1.20.1"})
@SourceDebugExtension(value={"SMAP\nConfigRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigRegistry.kt\ncom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,190:1\n1#2:191\n1855#3:192\n1549#3:193\n1620#3,3:194\n1856#3:197\n215#4,2:198\n*S KotlinDebug\n*F\n+ 1 ConfigRegistry.kt\ncom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry\n*L\n59#1:192\n63#1:193\n63#1:194,3\n59#1:197\n77#1:198,2\n*E\n"})
public final class ConfigRegistry {
    @NotNull
    private final String modId;
    @NotNull
    private final File configFile;
    @NotNull
    private final Map<String, ConfigProperty<?>> properties;
    private boolean frozen;

    public ConfigRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.modId = modId;
        this.configFile = new File(Platform.getConfigFolder().toFile(), this.modId + ".common.conf");
        this.properties = new LinkedHashMap();
    }

    @NotNull
    public final ConfigSupplier<Boolean> registerBoolean(@NotNull String key, boolean defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.frozen) {
            return new ConfigSupplier<Boolean>((Function0)new Function0<Boolean>(this, key){
                final /* synthetic */ ConfigRegistry this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    V v = ConfigRegistry.access$getProperties$p(this.this$0).get(this.$key);
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.registrate.registry.ConfigRegistry.BooleanConfigProperty");
                    return ((BooleanConfigProperty)v).getValue();
                }
            });
        }
        BooleanConfigProperty property = new BooleanConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<Boolean>((Function0)new Function0<Boolean>(property){
            final /* synthetic */ BooleanConfigProperty $property;
            {
                this.$property = $property;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$property.getValue();
            }
        });
    }

    @NotNull
    public final ConfigSupplier<Integer> registerInt(@NotNull String key, int defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.frozen) {
            return new ConfigSupplier<Integer>((Function0)new Function0<Integer>(this, key){
                final /* synthetic */ ConfigRegistry this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    V v = ConfigRegistry.access$getProperties$p(this.this$0).get(this.$key);
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.registrate.registry.ConfigRegistry.IntConfigProperty");
                    return ((IntConfigProperty)v).getValue();
                }
            });
        }
        IntConfigProperty property = new IntConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<Integer>((Function0)new Function0<Integer>(property){
            final /* synthetic */ IntConfigProperty $property;
            {
                this.$property = $property;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.$property.getValue();
            }
        });
    }

    @NotNull
    public final ConfigSupplier<Float> registerFloat(@NotNull String key, float defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.frozen) {
            return new ConfigSupplier<Float>((Function0)new Function0<Float>(this, key){
                final /* synthetic */ ConfigRegistry this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final Float invoke() {
                    V v = ConfigRegistry.access$getProperties$p(this.this$0).get(this.$key);
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.registrate.registry.ConfigRegistry.FloatConfigProperty");
                    return ((FloatConfigProperty)v).getValue();
                }
            });
        }
        FloatConfigProperty property = new FloatConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<Float>((Function0)new Function0<Float>(property){
            final /* synthetic */ FloatConfigProperty $property;
            {
                this.$property = $property;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                return this.$property.getValue();
            }
        });
    }

    @NotNull
    public final ConfigSupplier<String> registerString(@NotNull String key, @NotNull String defaultValue, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        if (this.frozen) {
            return new ConfigSupplier<String>((Function0)new Function0<String>(this, key){
                final /* synthetic */ ConfigRegistry this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    V v = ConfigRegistry.access$getProperties$p(this.this$0).get(this.$key);
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.dannbrown.deltaboxlib.registrate.registry.ConfigRegistry.StringConfigProperty");
                    return ((StringConfigProperty)v).getValue();
                }
            });
        }
        StringConfigProperty property = new StringConfigProperty(key, defaultValue, comment);
        this.properties.put(key, property);
        return new ConfigSupplier<String>((Function0)new Function0<String>(property){
            final /* synthetic */ StringConfigProperty $property;
            {
                this.$property = $property;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$property.getValue();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void loadConfig() {
        Object object;
        if (!this.configFile.exists()) {
            this.createConfigFile();
        }
        try {
            object = new FileReader(this.configFile);
            Throwable throwable = null;
            try {
                Object it = (FileReader)object;
                boolean bl = false;
                it = TextStreamsKt.readLines((Reader)((Reader)it));
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Object lines = object;
        boolean insideCommentBlock = false;
        Iterable $this$forEach$iv = (Iterable)lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigProperty<?> property;
            void $this$mapTo$iv$iv;
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"#", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)line, (CharSequence)"=", (boolean)false, (int)2, null)) continue;
            String[] stringArray = new String[]{"="};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List list = (List)destination$iv$iv;
            String key = (String)list.get(0);
            String value = (String)list.get(1);
            ConfigProperty<?> configProperty = property = this.properties.get(key);
            if (configProperty == null) continue;
            configProperty.loadValue(value);
        }
        this.saveConfig();
        this.frozen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveConfig() {
        try {
            Closeable closeable = new FileWriter(this.configFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                writer.write("# Config for " + this.modId + "\n");
                Map<String, ConfigProperty<?>> $this$forEach$iv = this.properties;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, ConfigProperty<?>>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    FileWriter fileWriter;
                    ConfigProperty<?> property;
                    String key;
                    block12: {
                        block11: {
                            void it;
                            Map.Entry<String, ConfigProperty<?>> element$iv;
                            Map.Entry<String, ConfigProperty<?>> entry = element$iv = iterator.next();
                            boolean bl2 = false;
                            key = entry.getKey();
                            property = entry.getValue();
                            fileWriter = writer;
                            object = property.getComment();
                            if (object == null) break block11;
                            String string = object;
                            FileWriter fileWriter2 = fileWriter;
                            boolean bl3 = false;
                            String string2 = "# " + (String)it;
                            fileWriter = fileWriter2;
                            object = string2;
                            if (string2 != null) break block12;
                        }
                        object = "";
                    }
                    fileWriter.write((String)object + "\n");
                    writer.write(key + "=" + property.toStringValue() + "\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void createConfigFile() {
        try {
            Files.createDirectories(Paths.get(this.configFile.getParent(), new String[0]), new FileAttribute[0]);
            this.configFile.createNewFile();
            FileWriter writer = new FileWriter(this.configFile);
            writer.write("# Config for " + this.modId + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void freeze() {
        this.frozen = true;
    }

    public final void clear() {
        this.properties.clear();
    }

    public static final /* synthetic */ Map access$getProperties$p(ConfigRegistry $this) {
        return $this.properties;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u000b\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$BooleanConfigProperty;", "Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigProperty;", "", "", "key", "defaultValue", "comment", "<init>", "(Ljava/lang/String;ZLjava/lang/String;)V", "getValue", "()Ljava/lang/Boolean;", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "Z", "deltaboxlib-2.1.1-common-1.20.1"})
    private static final class BooleanConfigProperty
    extends ConfigProperty<Boolean> {
        private boolean value;

        public BooleanConfigProperty(@NotNull String key, boolean defaultValue, @Nullable String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, defaultValue, comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = Boolean.parseBoolean(value);
        }

        @Override
        @NotNull
        public String toStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        @NotNull
        public Boolean getValue() {
            return this.value;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0005\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigProperty;", "T", "", "", "key", "defaultValue", "comment", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "getValue", "()Ljava/lang/Object;", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "Ljava/lang/String;", "getComment", "Ljava/lang/Object;", "getDefaultValue", "getKey", "deltaboxlib-2.1.1-common-1.20.1"})
    private static abstract class ConfigProperty<T> {
        @NotNull
        private final String key;
        private final T defaultValue;
        @Nullable
        private final String comment;

        public ConfigProperty(@NotNull String key, T defaultValue, @Nullable String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.defaultValue = defaultValue;
            this.comment = comment;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final T getDefaultValue() {
            return this.defaultValue;
        }

        @Nullable
        public final String getComment() {
            return this.comment;
        }

        public abstract void loadValue(@NotNull String var1);

        @NotNull
        public abstract String toStringValue();

        public abstract T getValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigSupplier;", "T", "", "Lkotlin/Function0;", "valueGetter", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "get", "()Ljava/lang/Object;", "value", "Ljava/lang/Object;", "Lkotlin/jvm/functions/Function0;", "deltaboxlib-2.1.1-common-1.20.1"})
    public static final class ConfigSupplier<T> {
        @NotNull
        private final Function0<T> valueGetter;
        @Nullable
        private T value;

        public ConfigSupplier(@NotNull Function0<? extends T> valueGetter) {
            Intrinsics.checkNotNullParameter(valueGetter, (String)"valueGetter");
            this.valueGetter = valueGetter;
        }

        public final T get() {
            if (this.value == null) {
                this.value = this.valueGetter.invoke();
            }
            T t = this.value;
            Intrinsics.checkNotNull(t);
            return t;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u000b\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$FloatConfigProperty;", "Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigProperty;", "", "", "key", "defaultValue", "comment", "<init>", "(Ljava/lang/String;FLjava/lang/String;)V", "getValue", "()Ljava/lang/Float;", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "F", "deltaboxlib-2.1.1-common-1.20.1"})
    private static final class FloatConfigProperty
    extends ConfigProperty<Float> {
        private float value;

        public FloatConfigProperty(@NotNull String key, float defaultValue, @Nullable String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, Float.valueOf(defaultValue), comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = Float.parseFloat(value);
        }

        @Override
        @NotNull
        public String toStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        @NotNull
        public Float getValue() {
            return Float.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u000b\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$IntConfigProperty;", "Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigProperty;", "", "", "key", "defaultValue", "comment", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/Integer;", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "()Ljava/lang/String;", "I", "deltaboxlib-2.1.1-common-1.20.1"})
    private static final class IntConfigProperty
    extends ConfigProperty<Integer> {
        private int value;

        public IntConfigProperty(@NotNull String key, int defaultValue, @Nullable String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(key, defaultValue, comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = Integer.parseInt(value);
        }

        @Override
        @NotNull
        public String toStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        @NotNull
        public Integer getValue() {
            return this.value;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\tR\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$StringConfigProperty;", "Lcom/dannbrown/deltaboxlib/registrate/registry/ConfigRegistry$ConfigProperty;", "", "key", "defaultValue", "comment", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "value", "", "loadValue", "(Ljava/lang/String;)V", "toStringValue", "Ljava/lang/String;", "deltaboxlib-2.1.1-common-1.20.1"})
    private static final class StringConfigProperty
    extends ConfigProperty<String> {
        @NotNull
        private String value;

        public StringConfigProperty(@NotNull String key, @NotNull String defaultValue, @Nullable String comment) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            super(key, defaultValue, comment);
            this.value = defaultValue;
        }

        @Override
        public void loadValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @Override
        @NotNull
        public String toStringValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }
    }
}

