/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.playerlist;

import fi.fabianadrian.playerlist.command.PlayerListCommand;
import fi.fabianadrian.playerlist.configuration.Configuration;
import fi.fabianadrian.playerlist.configuration.ConfigurationManager;
import fi.fabianadrian.playerlist.dependency.org.bstats.bukkit.Metrics;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.ConfigurateException;
import fi.fabianadrian.playerlist.list.ListManager;
import fi.fabianadrian.playerlist.listener.JoinListener;
import fi.fabianadrian.playerlist.locale.TranslationManager;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerList
extends JavaPlugin {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private ConfigurationManager configurationManager;
    private ListManager listManager;

    public void onEnable() {
        new TranslationManager(this);
        this.configurationManager = new ConfigurationManager(this);
        try {
            this.configurationManager.reload();
        }
        catch (ConfigurateException e) {
            this.getSLF4JLogger().error("Couldn't load configuration", (Throwable)e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.listManager = new ListManager(this);
        this.listManager.reload();
        this.registerCommands();
        this.registerListeners();
        new Metrics(this, 25811);
    }

    public Configuration configuration() {
        return this.configurationManager.configuration();
    }

    public void reload() throws ConfigurateException {
        this.configurationManager.reload();
        this.listManager.reload();
    }

    public ScheduledExecutorService executorService() {
        return this.executorService;
    }

    public CompletableFuture<List<Player>> onlinePlayers() {
        CompletableFuture<List<Player>> onlinePlayersFuture = new CompletableFuture<List<Player>>();
        this.getServer().getScheduler().runTask((Plugin)this, () -> onlinePlayersFuture.complete(new ArrayList(this.getServer().getOnlinePlayers())));
        return onlinePlayersFuture;
    }

    public ListManager playerListManager() {
        return this.listManager;
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> ((Commands)commands.registrar()).register(new PlayerListCommand(this).command()));
    }

    private void registerListeners() {
        PluginManager manager = this.getServer().getPluginManager();
        List.of(new JoinListener(this)).forEach(listener -> manager.registerEvents((Listener)listener, (Plugin)this));
    }
}

