/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.playerlist.configuration;

import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.CommentedConfigurationNode;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.ConfigurateException;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.ConfigurationOptions;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.objectmapping.ObjectMapper;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.serialize.SerializationException;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.yaml.NodeStyle;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import java.nio.file.Path;
import java.util.function.UnaryOperator;

public final class ConfigurationLoader<C> {
    private final YamlConfigurationLoader loader;
    private final ObjectMapper<C> mapper;

    public ConfigurationLoader(Class<C> configClass, Path configPath, UnaryOperator<ConfigurationOptions> options) {
        try {
            this.mapper = ObjectMapper.factory().get(configClass);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Failed to initialize an object mapper for type: " + configClass.getSimpleName(), e);
        }
        this.loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).nodeStyle(NodeStyle.BLOCK).indent(2).defaultOptions(options)).build();
    }

    public C load() throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
        return this.mapper.load(node);
    }

    public void save(C config) throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.createNode();
        this.mapper.save(config, node);
        this.loader.save(node);
    }
}

