/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.serialize;

import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.serialize.ScalarSerializer;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.serialize.SerializationException;
import fi.fabianadrian.playerlist.dependency.org.spongepowered.configurate.util.CheckedFunction;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;

final class FunctionScalarSerializer<T>
extends ScalarSerializer<T> {
    private final CheckedFunction<Object, T, SerializationException> deserializer;
    private final BiFunction<T, Predicate<Class<?>>, Object> serializer;

    FunctionScalarSerializer(Type type, CheckedFunction<Object, T, SerializationException> deserializer, BiFunction<T, Predicate<Class<?>>, Object> serializer) {
        super(type);
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    @Override
    public T deserialize(Type type, Object obj) throws SerializationException {
        try {
            return this.deserializer.apply(obj);
        }
        catch (SerializationException ex) {
            ex.initType(type);
            throw ex;
        }
    }

    @Override
    public Object serialize(T item, Predicate<Class<?>> typeSupported) {
        return this.serializer.apply(item, typeSupported);
    }
}

