/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.playerlist.list;

import fi.fabianadrian.playerlist.PlayerList;
import fi.fabianadrian.playerlist.configuration.Configuration;
import fi.fabianadrian.playerlist.list.sorting.Sorter;
import io.github.miniplaceholders.api.MiniPlaceholders;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;

public final class ListManager {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final PlayerList playerList;
    private ScheduledFuture<?> scheduledFuture;
    private Comparator<Player> comparator;
    private boolean isMiniPlaceholdersAvailable = false;

    public ListManager(PlayerList playerList) {
        this.playerList = playerList;
    }

    public void reload() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.isMiniPlaceholdersAvailable = this.playerList.getServer().getPluginManager().isPluginEnabled("MiniPlaceholders");
        int refreshInterval = this.playerList.configuration().placeholderRefreshInterval();
        this.scheduledFuture = this.playerList.executorService().scheduleAtFixedRate(() -> this.playerList.onlinePlayers().thenAccept(players -> {
            players.forEach(this::update);
            this.updateOrder((List<Player>)players);
        }), 0L, refreshInterval, TimeUnit.SECONDS);
        this.constructComparatorFromSorters();
    }

    public void update(Player player) {
        ArrayList headerLines = new ArrayList();
        ArrayList footerLines = new ArrayList();
        Configuration configuration = this.playerList.configuration();
        if (this.isMiniPlaceholdersAvailable) {
            TagResolver miniPlaceholdersResolver = MiniPlaceholders.audienceGlobalPlaceholders();
            configuration.header().forEach(line -> headerLines.add(this.miniMessage.deserialize(line, (Pointered)player, miniPlaceholdersResolver)));
            configuration.footer().forEach(line -> footerLines.add(this.miniMessage.deserialize(line, (Pointered)player, miniPlaceholdersResolver)));
        } else {
            configuration.header().forEach(line -> headerLines.add(this.miniMessage.deserialize(line)));
            configuration.footer().forEach(line -> footerLines.add(this.miniMessage.deserialize(line)));
        }
        player.sendPlayerListHeaderAndFooter(Component.join((JoinConfiguration)JoinConfiguration.newlines(), headerLines), Component.join((JoinConfiguration)JoinConfiguration.newlines(), footerLines));
        this.updateCustomName(player);
    }

    public void updateOrder(List<Player> players) {
        if (this.comparator == null) {
            return;
        }
        players.sort(this.comparator);
        for (int i = 0; i < players.size(); ++i) {
            players.get(i).setPlayerListOrder(i);
        }
    }

    private void updateCustomName(Player player) {
        String nameString = this.playerList.configuration().playerListName();
        if (nameString.isBlank()) {
            player.playerListName(null);
            return;
        }
        Component nameComponent = this.isMiniPlaceholdersAvailable ? this.miniMessage.deserialize(nameString, (Pointered)player, MiniPlaceholders.audienceGlobalPlaceholders()) : this.miniMessage.deserialize((Object)nameString);
        player.playerListName(nameComponent);
    }

    private void constructComparatorFromSorters() {
        Comparator<Player> finalComparator = null;
        for (Sorter sorter : this.playerList.configuration().sorters()) {
            Comparator<Player> currentComparator = sorter.comparator();
            finalComparator = finalComparator == null ? currentComparator : finalComparator.thenComparing(currentComparator);
        }
        this.comparator = finalComparator;
    }
}

