/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.playerlist.list.sorting;

import fi.fabianadrian.playerlist.PlayerList;
import fi.fabianadrian.playerlist.list.sorting.Sorter;
import fi.fabianadrian.playerlist.list.sorting.SorterType;
import fi.fabianadrian.playerlist.list.sorting.SortingOrder;
import io.github.miniplaceholders.api.MiniPlaceholders;
import java.util.Comparator;
import java.util.Locale;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;

public final class PlaceholderSorter
extends Sorter {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final String placeholder;
    private final boolean caseSensitive;

    public PlaceholderSorter(PlayerList plugin, SortingOrder order, String placeholder, boolean caseSensitive) {
        super(SorterType.PLACEHOLDER, order);
        this.placeholder = placeholder;
        this.caseSensitive = caseSensitive;
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        switch (placeholder.charAt(0)) {
            case '<': {
                if (!pluginManager.isPluginEnabled("MiniPlaceholders")) {
                    plugin.getSLF4JLogger().warn("MiniPlaceholders is not enabled. Placeholder sorter for {} will be non-functional", (Object)placeholder);
                    return;
                }
                this.comparator = Comparator.comparing(this::parseMiniPlaceholders);
                break;
            }
            case '%': {
                if (!pluginManager.isPluginEnabled("PlaceholderAPI")) {
                    plugin.getSLF4JLogger().warn("PlaceholderAPI is not enabled. Placeholder sorter for {} will be non-functional", (Object)placeholder);
                    return;
                }
                this.comparator = Comparator.comparing(this::parsePlaceholderAPI);
                break;
            }
            default: {
                plugin.getSLF4JLogger().warn("{} is neither MiniPlaceholders or PlaceholderAPI placeholder. Sorter will be non-functional", (Object)placeholder);
            }
        }
    }

    public String placeholder() {
        return this.placeholder;
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    private String parseMiniPlaceholders(Player player) {
        Component deserialized = this.miniMessage.deserialize(this.placeholder, (Pointered)player, MiniPlaceholders.audienceGlobalPlaceholders());
        String serialized = PlainTextComponentSerializer.plainText().serialize(deserialized);
        if (!this.caseSensitive) {
            serialized = serialized.toLowerCase(Locale.ROOT);
        }
        return serialized;
    }

    private String parsePlaceholderAPI(Player player) {
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)this.placeholder);
        if (!this.caseSensitive) {
            parsed = parsed.toLowerCase(Locale.ROOT);
        }
        return parsed;
    }
}

