/*
 * Decompiled with CFR 0.152.
 */
package willfrydev.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import willfrydev.xLogin;

public class AdminCommand
implements CommandExecutor,
TabCompleter {
    private final xLogin plugin;
    private static final Pattern IP_PATTERN = Pattern.compile("^([0-9]{1,3}\\.){3}[0-9]{1,3}$");

    public AdminCommand(xLogin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("xlogin.admin")) {
            sender.sendMessage(this.plugin.getMsg("general.no_permission"));
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.sendHelpMessage(sender);
                break;
            }
            case "reload": {
                this.plugin.reloadPlugin();
                sender.sendMessage(this.plugin.getMsg("admin.reload_success"));
                this.plugin.getLogManager().logAdminAction(sender.getName(), "Ejecut\u00f3 /xlogin reload");
                break;
            }
            case "gui": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("Este comando solo puede ser usado por un jugador.");
                    return true;
                }
                this.plugin.getGuiManager().openPlayerList((Player)sender, 0);
                break;
            }
            case "delacc": {
                break;
            }
            case "blockip": {
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getMsg("security.admin_block_usage"));
                    return true;
                }
                this.handleIpBlock(sender, args[1], true);
                break;
            }
            case "unblockip": {
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getMsg("security.admin_unblock_usage"));
                    return true;
                }
                this.handleIpBlock(sender, args[1], false);
                break;
            }
            case "spawn": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("Este comando solo puede ser usado por un jugador.");
                    return true;
                }
                this.handleSpawn((Player)sender);
                break;
            }
            default: {
                sender.sendMessage(this.plugin.getMsg("admin.unknown_subcommand"));
            }
        }
        return true;
    }

    private void handleIpBlock(CommandSender sender, String ipAddress, boolean block) {
        if (!IP_PATTERN.matcher(ipAddress).matches()) {
            sender.sendMessage(this.plugin.getMsg("security.admin_invalid_ip"));
            return;
        }
        this.plugin.getStorage().loadIpData(ipAddress).thenAccept(ipData -> {
            ipData.setBlocked(block);
            this.plugin.getStorage().saveIpData(ipAddress, (xLogin.IpData)ipData);
            String message = block ? this.plugin.getMsg("security.admin_ip_blocked") : this.plugin.getMsg("security.admin_ip_unblocked");
            sender.sendMessage(message.replace("{ip}", ipAddress));
            this.plugin.getLogManager().logAdminAction(sender.getName(), (block ? "Bloque\u00f3" : "Desbloque\u00f3") + " la IP " + ipAddress);
        });
    }

    private void handleSpawn(Player player) {
        if (!this.plugin.getConfig().getBoolean("spawn-location.enabled")) {
            player.sendMessage(this.plugin.getMsg("admin.spawn.not_enabled"));
            return;
        }
        World world = Bukkit.getWorld((String)this.plugin.getConfig().getString("spawn-location.world", "world"));
        if (world == null) {
            player.sendMessage(this.plugin.getMsg("admin.spawn.not_set"));
            return;
        }
        double x = this.plugin.getConfig().getDouble("spawn-location.x");
        double y = this.plugin.getConfig().getDouble("spawn-location.y");
        double z = this.plugin.getConfig().getDouble("spawn-location.z");
        float yaw = (float)this.plugin.getConfig().getDouble("spawn-location.yaw");
        float pitch = (float)this.plugin.getConfig().getDouble("spawn-location.pitch");
        player.teleport(new Location(world, x, y, z, yaw, pitch));
        player.sendMessage(this.plugin.getMsg("admin.spawn.teleported"));
    }

    private void sendHelpMessage(CommandSender sender) {
        this.plugin.getMsgList("admin.help_message").forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("xlogin.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], Arrays.asList("help", "reload", "gui", "delacc", "blockip", "unblockip", "spawn"), new ArrayList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("delacc")) {
            return null;
        }
        return Collections.emptyList();
    }
}

