/*
 * Decompiled with CFR 0.152.
 */
package willfrydev.manager;

import java.time.Instant;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import willfrydev.xLogin;

public class CaptchaManager {
    private final xLogin plugin;
    private final Map<UUID, CaptchaData> pendingCaptchas = new ConcurrentHashMap<UUID, CaptchaData>();
    private final Random random = new Random();

    public CaptchaManager(xLogin plugin) {
        this.plugin = plugin;
    }

    public void startCaptcha(Player player, String password) {
        if (this.pendingCaptchas.containsKey(player.getUniqueId())) {
            player.sendMessage(this.plugin.getMsg("captcha_already_pending"));
            return;
        }
        String allowedChars = this.plugin.getConfig().getString("captcha.allowed-characters", "ABCDEFGHJKLMNOPQRSTUVWXYZ123456789");
        int codeLength = this.plugin.getConfig().getInt("captcha.code-length", 6);
        StringBuilder codeBuilder = new StringBuilder();
        for (int i = 0; i < codeLength; ++i) {
            codeBuilder.append(allowedChars.charAt(this.random.nextInt(allowedChars.length())));
        }
        String code = codeBuilder.toString();
        long timeout = this.plugin.getConfig().getLong("captcha.timeout-seconds", 120L);
        CaptchaData captchaData = new CaptchaData(password, code, timeout);
        this.pendingCaptchas.put(player.getUniqueId(), captchaData);
        player.sendMessage(this.plugin.getMsg("captcha_prompt").replace("{code}", code));
    }

    public void verifyCaptcha(Player player, String providedCode) {
        CaptchaData captchaData = this.pendingCaptchas.get(player.getUniqueId());
        if (captchaData == null) {
            player.sendMessage(this.plugin.getMsg("captcha_no_pending"));
            return;
        }
        if (captchaData.isExpired()) {
            this.pendingCaptchas.remove(player.getUniqueId());
            player.sendMessage(this.plugin.getMsg("captcha_timeout"));
            return;
        }
        if (captchaData.getCode().equals(providedCode.toUpperCase())) {
            this.pendingCaptchas.remove(player.getUniqueId());
            this.plugin.completeRegistration(player, captchaData.getPassword());
        } else {
            player.sendMessage(this.plugin.getMsg("captcha_fail"));
        }
    }

    private static class CaptchaData {
        private final String password;
        private final String code;
        private final Instant expiryTime;

        public CaptchaData(String password, String code, long timeoutSeconds) {
            this.password = password;
            this.code = code;
            this.expiryTime = Instant.now().plusSeconds(timeoutSeconds);
        }

        public String getPassword() {
            return this.password;
        }

        public String getCode() {
            return this.code;
        }

        public boolean isExpired() {
            return Instant.now().isAfter(this.expiryTime);
        }
    }
}

