/*
 * Decompiled with CFR 0.152.
 */
package willfrydev.manager;

import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.file.FileConfiguration;
import willfrydev.xLogin;

public class EmailManager {
    private final xLogin plugin;
    private final Session mailSession;
    private final String fromEmail;
    private final String fromName;
    private final boolean isEnabled;

    public EmailManager(xLogin plugin) {
        this.plugin = plugin;
        FileConfiguration emailConfig = plugin.getEmailConfig();
        this.isEnabled = emailConfig.getBoolean("enable", false);
        if (!this.isEnabled) {
            this.mailSession = null;
            this.fromEmail = null;
            this.fromName = null;
            return;
        }
        this.fromEmail = emailConfig.getString("authentication.email");
        this.fromName = emailConfig.getString("authentication.from");
        final String user = emailConfig.getString("authentication.user");
        final String password = emailConfig.getString("authentication.password");
        Properties props = new Properties();
        props.put("mail.smtp.host", emailConfig.getString("authentication.host"));
        props.put("mail.smtp.port", emailConfig.getString("authentication.port"));
        props.put("mail.smtp.auth", "true");
        String encryption = emailConfig.getString("authentication.encryption", "TLS").toUpperCase();
        if (encryption.equals("TLS")) {
            props.put("mail.smtp.starttls.enable", "true");
        } else if (encryption.equals("SSL")) {
            props.put("mail.smtp.socketFactory.port", emailConfig.getString("authentication.port"));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        this.mailSession = Session.getInstance(props, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password);
            }
        });
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String generateVerificationCode() {
        SecureRandom random = new SecureRandom();
        int num = random.nextInt(900000) + 100000;
        return String.valueOf(num);
    }

    public CompletableFuture<Boolean> sendVerificationEmail(String toEmail, String code) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                MimeMessage message = new MimeMessage(this.mailSession);
                ((Message)message).setFrom(new InternetAddress(this.fromEmail, this.fromName));
                ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(toEmail));
                ((Message)message).setSubject("C\u00f3digo de Verificaci\u00f3n para tu Cuenta");
                String content = "<h1>Verificaci\u00f3n de Cuenta</h1><p>Tu c\u00f3digo de verificaci\u00f3n para el servidor es:</p><h2 style='color: #1e90ff;'>" + code + "</h2><p>Si no has solicitado este c\u00f3digo, ignora este mensaje.</p>";
                message.setContent(content, "text/html; charset=utf-8");
                Transport.send(message);
                return true;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("No se pudo enviar el correo de verificaci\u00f3n: " + e.getMessage());
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> sendRecoveryEmail(String toEmail, String code) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                MimeMessage message = new MimeMessage(this.mailSession);
                ((Message)message).setFrom(new InternetAddress(this.fromEmail, this.fromName));
                ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(toEmail));
                ((Message)message).setSubject("Recuperaci\u00f3n de Contrase\u00f1a");
                String content = "<h1>Recuperaci\u00f3n de Cuenta</h1><p>Hola,</p><p>Has solicitado recuperar tu contrase\u00f1a. Usa el siguiente comando en el juego con tu nueva contrase\u00f1a:</p><p><code>/email recover &lt;nueva_contrase\u00f1a&gt; " + code + "</code></p><p>Si no has solicitado esto, puedes ignorar este mensaje de forma segura.</p>";
                message.setContent(content, "text/html; charset=utf-8");
                Transport.send(message);
                return true;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("No se pudo enviar el correo de recuperaci\u00f3n: " + e.getMessage());
                return false;
            }
        });
    }
}

