/*
 * Decompiled with CFR 0.152.
 */
package willfrydev.manager;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import willfrydev.xLogin;

public class GuiManager {
    private final xLogin plugin;
    public static final String PLAYER_LIST_TITLE_PREFIX = "Lista de Jugadores";

    public GuiManager(xLogin plugin) {
        this.plugin = plugin;
    }

    public void openPlayerList(Player player, int page) {
        int pageSize = 45;
        int offset = page * pageSize;
        this.plugin.getStorage().getTotalPlayerCount().thenAcceptBoth(this.plugin.getStorage().getPlayerList(offset, pageSize), (totalPlayers, players) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            int totalPages = totalPlayers == 0 ? 1 : (int)Math.ceil((double)totalPlayers.intValue() / (double)pageSize);
            String title = "Lista de Jugadores (P\u00e1gina " + (page + 1) + "/" + totalPages + ")";
            Inventory gui = Bukkit.createInventory(null, (int)54, (String)title);
            for (int i = 0; i < players.size(); ++i) {
                String playerName = (String)((Map)players.get(i)).get("username");
                UUID playerUUID = UUID.fromString((String)((Map)players.get(i)).get("uuid"));
                ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
                if (meta != null) {
                    meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)playerUUID));
                    meta.setDisplayName(String.valueOf(ChatColor.AQUA) + playerName);
                    meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "UUID: " + playerUUID.toString(), "", String.valueOf(ChatColor.YELLOW) + "Haz clic para ver m\u00e1s detalles."));
                    playerHead.setItemMeta((ItemMeta)meta);
                }
                gui.setItem(i, playerHead);
            }
            if (page > 0) {
                gui.setItem(45, this.createNavItem(Material.ARROW, String.valueOf(ChatColor.GREEN) + "\u25c4 P\u00e1gina Anterior", page - 1));
            }
            gui.setItem(49, this.createNavItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Cerrar", -1));
            if (page + 1 < totalPages) {
                gui.setItem(53, this.createNavItem(Material.ARROW, String.valueOf(ChatColor.GREEN) + "P\u00e1gina Siguiente \u25ba", page + 1));
            }
            player.openInventory(gui);
        }));
    }

    private ItemStack createNavItem(Material material, String name, int page) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLocalizedName(String.valueOf(page));
        item.setItemMeta(meta);
        return item;
    }
}

