/*
 * Decompiled with CFR 0.152.
 */
package willfrydev;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.geysermc.floodgate.api.FloodgateApi;
import org.mindrot.jbcrypt.BCrypt;
import willfrydev.commands.AdminCommand;
import willfrydev.commands.CaptchaCommand;
import willfrydev.commands.EmailCommand;
import willfrydev.dbs.Storage;
import willfrydev.manager.CaptchaManager;
import willfrydev.manager.EmailManager;
import willfrydev.manager.GuiManager;
import willfrydev.manager.H2Manager;
import willfrydev.manager.LogManager;
import willfrydev.manager.MySQLManager;
import willfrydev.metricas.Metrics;

public final class xLogin
extends JavaPlugin
implements Listener,
CommandExecutor {
    private Storage storage;
    private final Map<UUID, Boolean> loggedInPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, BukkitTask> timeoutTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, SessionData> playerSessions = new ConcurrentHashMap<UUID, SessionData>();
    private final Map<UUID, String> pending2FACodes = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Boolean> premiumConfirmations = new ConcurrentHashMap<UUID, Boolean>();
    private FileConfiguration messagesConfig;
    private FileConfiguration emailConfig;
    private boolean floodgateApiAvailable = false;
    private LogManager logManager;
    private CaptchaManager captchaManager;
    private EmailManager emailManager;
    private GuiManager guiManager;
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public void onEnable() {
        this.getLogger().info(" ");
        this.getLogger().info(" __  __ / /  ___   __ _(_)_ __  ");
        this.getLogger().info(" \\ \\/ // /  / _ \\ / _` | | '_ \\ ");
        this.getLogger().info("  >  < / /__| (_) | (_| | | | | |");
        this.getLogger().info(" /_/\\_\\\\____/\\___/ \\__, |_|_| |_|");
        this.getLogger().info("                   |___/         ");
        this.getLogger().info(" ");
        this.getLogger().info(" Hecho por xPlugins - WillfryDev - 777 Studios");
        this.getLogger().info(" ");
        if (!this.setupConfigs()) {
            return;
        }
        this.logManager = new LogManager(this);
        this.captchaManager = new CaptchaManager(this);
        this.emailManager = new EmailManager(this);
        this.guiManager = new GuiManager(this);
        String storageMethod = this.getConfig().getString("storage.method", "H2").toUpperCase();
        this.storage = storageMethod.equals("MYSQL") ? new MySQLManager(this) : new H2Manager(this);
        this.storage.connect();
        if (Bukkit.getPluginManager().isPluginEnabled("floodgate")) {
            this.floodgateApiAvailable = true;
            this.getLogger().info("Detectado Floodgate. El soporte para GeyserMC est\u00e1 activado.");
        }
        this.registerCommandsAndEvents();
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        int pluginId = 22222;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("storage_method", () -> this.getConfig().getString("storage.method", "H2").toUpperCase()));
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "xLogin activado correctamente usando el m\u00e9todo de almacenamiento: " + storageMethod);
        this.getLogger().info(" ");
    }

    public void onDisable() {
        if (this.storage != null) {
            this.storage.close();
        }
        this.getLogger().info(" ");
        this.getLogger().info(String.valueOf(ChatColor.RED) + " __  __ / /  ___   __ _(_)_ __  ");
        this.getLogger().info(String.valueOf(ChatColor.RED) + " \\ \\/ // /  / _ \\ / _` | | '_ \\ ");
        this.getLogger().info(String.valueOf(ChatColor.RED) + "  >  < / /__| (_) | (_| | | | | |");
        this.getLogger().info(String.valueOf(ChatColor.RED) + " /_/\\_\\\\____/\\___/ \\__, |_|_| |_|");
        this.getLogger().info(String.valueOf(ChatColor.RED) + "                   |___/         ");
        this.getLogger().info(" ");
        this.getLogger().info(String.valueOf(ChatColor.RED) + "xLogin ha sido desactivado.");
        this.getLogger().info(" ");
    }

    public Map<UUID, Boolean> getLoggedInPlayers() {
        return this.loggedInPlayers;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public FileConfiguration getEmailConfig() {
        return this.emailConfig;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.setupConfigs();
        if (this.storage != null) {
            this.storage.close();
            this.storage.connect();
        }
    }

    private boolean setupConfigs() {
        File twofaFolder;
        this.saveDefaultConfig();
        File messagesFolder = new File(this.getDataFolder(), "messages");
        if (!messagesFolder.exists()) {
            messagesFolder.mkdirs();
        }
        if (!(twofaFolder = new File(this.getDataFolder(), "2fa")).exists()) {
            twofaFolder.mkdirs();
        }
        this.saveResource("messages/messages_es.yml", false);
        this.saveResource("messages/messages_en.yml", false);
        this.saveResource("2fa/email.yml", false);
        String lang = this.getConfig().getString("general.language", "es");
        File messagesFile = new File(this.getDataFolder(), "messages/messages_" + lang + ".yml");
        if (!messagesFile.exists()) {
            this.getLogger().warning("El archivo de idioma configurado '" + messagesFile.getName() + "' no fue encontrado. Usando 'es' por defecto.");
            messagesFile = new File(this.getDataFolder(), "messages/messages_es.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        File emailFile = new File(twofaFolder, "email.yml");
        this.emailConfig = YamlConfiguration.loadConfiguration((File)emailFile);
        return true;
    }

    private void registerCommandsAndEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        AdminCommand adminCommand = new AdminCommand(this);
        this.getCommand("xlogin").setExecutor((CommandExecutor)adminCommand);
        this.getCommand("xlogin").setTabCompleter((TabCompleter)adminCommand);
        this.getCommand("register").setExecutor((CommandExecutor)this);
        this.getCommand("login").setExecutor((CommandExecutor)this);
        this.getCommand("captcha").setExecutor((CommandExecutor)new CaptchaCommand(this.captchaManager));
        this.getCommand("email").setExecutor((CommandExecutor)new EmailCommand(this, this.emailManager));
        this.getCommand("changepassword").setExecutor((CommandExecutor)this);
        this.getCommand("premium").setExecutor((CommandExecutor)this);
        this.getCommand("unregister").setExecutor((CommandExecutor)this);
    }

    public String getMsg(String key) {
        String message = this.messagesConfig.getString(key);
        return this.translateHexColorCodes((String)(message != null ? message : "&cMissing message: " + key));
    }

    public List<String> getMsgList(String key) {
        List lines = this.messagesConfig.getStringList(key);
        lines.replaceAll(this::translateHexColorCodes);
        return lines;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.loggedInPlayers.put(uuid, false);
        if (this.floodgateApiAvailable && FloodgateApi.getInstance().isFloodgatePlayer(uuid) && this.getConfig().getBoolean("geyser-support.auto-login-bedrock", true)) {
            this.handleSuccessfulLogin(player, null);
            return;
        }
        boolean isPlayerAuthenticatedByProxy = Bukkit.getOnlineMode();
        if (this.getConfig().getBoolean("protection.login-methods.auto-login-premium", true) && isPlayerAuthenticatedByProxy) {
            this.handleSuccessfulLogin(player, null);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> this.storage.loadPlayerData(uuid).thenAccept(userData -> Bukkit.getScheduler().runTask((Plugin)this, () -> {
            if (!player.isOnline()) {
                return;
            }
            String playerIP = player.getAddress().getAddress().getHostAddress();
            SessionData session = this.playerSessions.get(uuid);
            if (this.getConfig().getBoolean("protection.login-methods.session.enabled", true) && session != null && session.isValid(playerIP)) {
                this.handleSuccessfulLogin(player, (UserData)userData);
                return;
            }
            if (this.getConfig().getBoolean("protection.login-methods.auto-login-by-ip.enabled", true) && userData != null && playerIP.equals(userData.getLastIp())) {
                this.handleSuccessfulLogin(player, (UserData)userData);
                return;
            }
            if (this.getConfig().getBoolean("protection.effects.blindness", true)) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 255, false, false));
            }
            if (userData != null) {
                player.sendMessage(this.getMsg("commands.login.prompt"));
                this.sendTitle(player, "before-login");
            } else {
                player.sendMessage(this.getMsg("commands.register.prompt"));
                this.sendTitle(player, "before-register");
            }
            this.startLoginTimeout(player);
        })));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (this.loggedInPlayers.getOrDefault(uuid, false).booleanValue() && this.getConfig().getBoolean("protection.login-methods.session.enabled", true)) {
            long duration = this.getConfig().getLong("protection.login-methods.session.timeout-minutes", 5L);
            if (event.getPlayer().getAddress() != null) {
                this.playerSessions.put(uuid, new SessionData(event.getPlayer().getAddress().getAddress().getHostAddress(), duration));
            }
        } else {
            this.playerSessions.remove(uuid);
        }
        this.loggedInPlayers.remove(uuid);
        this.pending2FACodes.remove(uuid);
        this.premiumConfirmations.remove(uuid);
        if (this.timeoutTasks.containsKey(uuid)) {
            this.timeoutTasks.remove(uuid).cancel();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.loggedInPlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        if (this.pending2FACodes.containsKey(player.getUniqueId())) {
            String command = event.getMessage().toLowerCase();
            if (command.startsWith("/email verify") || command.startsWith("/mail verify")) {
                return;
            }
            event.setCancelled(true);
            player.sendMessage(this.getMsg("commands.email.verification_required"));
            return;
        }
        String command = event.getMessage().substring(1).split(" ")[0].toLowerCase();
        List allowedCommands = this.getConfig().getStringList("security.allowed-commands-before-login");
        if (allowedCommands.contains(command) || command.equals("login") || command.equals("register") || command.equals("captcha") || command.equals("email") || command.equals("mail")) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(this.getMsg("commands.login.prompt"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        if (!title.startsWith("Lista de Jugadores")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (clickedItem.getType() == Material.BARRIER) {
            player.closeInventory();
            return;
        }
        if (clickedItem.getType() == Material.ARROW) {
            int page = Integer.parseInt(clickedItem.getItemMeta().getLocalizedName());
            player.closeInventory();
            this.guiManager.openPlayerList(player, page);
        }
        if (clickedItem.getType() == Material.PLAYER_HEAD) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Pr\u00f3ximamente: \u00a1Pantalla de detalles para " + clickedItem.getItemMeta().getDisplayName() + "!");
            player.closeInventory();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        String cmd = command.getName().toLowerCase();
        boolean isLoggedIn = this.loggedInPlayers.getOrDefault(player.getUniqueId(), false);
        if (isLoggedIn && (cmd.equals("login") || cmd.equals("register"))) {
            player.sendMessage(this.getMsg("general.already_logged_in"));
            return true;
        }
        if (!isLoggedIn && (cmd.equals("changepassword") || cmd.equals("premium") || cmd.equals("unregister"))) {
            player.sendMessage(this.getMsg("commands.login.prompt"));
            return true;
        }
        switch (cmd) {
            case "register": {
                this.handleRegister(player, args);
                break;
            }
            case "login": {
                this.handleLogin(player, args);
                break;
            }
            case "changepassword": {
                this.handleChangePassword(player, args);
                break;
            }
            case "premium": {
                this.handlePremium(player, args);
                break;
            }
            case "unregister": {
                this.handleUnregister(player, args);
            }
        }
        return true;
    }

    private void handleRegister(Player player, String[] args) {
        String playerIP = player.getAddress().getAddress().getHostAddress();
        this.storage.loadIpData(playerIP).thenAccept(ipData -> {
            if (ipData.isBlocked()) {
                player.sendMessage(this.getMsg("security.ip_is_blocked"));
                return;
            }
            int limit = this.getConfig().getInt("ip-security.registration-limit.limit", 3);
            if (this.getConfig().getBoolean("ip-security.registration-limit.enabled") && ipData.getRegistrationCount() >= limit) {
                player.sendMessage(this.getMsg("security.ip_limit_reached"));
                return;
            }
            this.storage.loadPlayerData(player.getUniqueId()).thenAccept(existingData -> {
                if (existingData != null) {
                    player.sendMessage(this.getMsg("commands.register.already_registered"));
                    return;
                }
                if (args.length != 2 || !args[0].equals(args[1])) {
                    player.sendMessage(this.getMsg("commands.register.password_mismatch"));
                    return;
                }
                String password = args[0];
                if (this.getConfig().getBoolean("passwords.strength-meter.enabled", true)) {
                    PasswordStrength strength = this.checkPasswordStrength(password);
                    String strengthBar = this.getStrengthAsBar(strength);
                    player.sendMessage(this.getMsg("security.password_strength").replace("{strength_bar}", strengthBar));
                    if (this.getConfig().getBoolean("passwords.strength-meter.prevent-weak-passwords", true) && strength == PasswordStrength.WEAK) {
                        player.sendMessage(this.getMsg("security.cannot_use_weak_password"));
                        return;
                    }
                }
                int min2 = this.getConfig().getInt("passwords.size.min", 4);
                int max = this.getConfig().getInt("passwords.size.max", 20);
                if (password.length() < min2) {
                    player.sendMessage(this.getMsg("commands.register.password_too_short").replace("{min}", String.valueOf(min2)));
                    return;
                }
                if (password.length() > max) {
                    player.sendMessage(this.getMsg("commands.register.password_too_long").replace("{max}", String.valueOf(max)));
                    return;
                }
                if (this.getConfig().getBoolean("captcha.enabled", true)) {
                    this.captchaManager.startCaptcha(player, password);
                } else {
                    this.completeRegistration(player, password);
                }
            });
        });
    }

    public void completeRegistration(Player player, String password) {
        String playerIP = player.getAddress().getAddress().getHostAddress();
        this.storage.loadIpData(playerIP).thenAccept(ipData -> {
            if (ipData.isBlocked() || this.getConfig().getBoolean("ip-security.registration-limit.enabled") && ipData.getRegistrationCount() >= this.getConfig().getInt("ip-security.registration-limit.limit", 3)) {
                return;
            }
            this.logManager.logRegistration(player.getName(), playerIP);
            ipData.incrementRegistrationCount();
            this.storage.saveIpData(playerIP, (IpData)ipData);
            String hashedPassword = BCrypt.hashpw(password, BCrypt.gensalt());
            UserData newUserData = new UserData(hashedPassword, playerIP, false, null);
            this.storage.savePlayerData(player, newUserData);
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                player.sendMessage(this.getMsg("commands.captcha.success"));
                this.handleSuccessfulLogin(player, newUserData);
            });
        });
    }

    private void handleLogin(Player player, String[] args) {
        if (args.length != 1) {
            player.sendMessage(this.getMsg("commands.login.error"));
            return;
        }
        this.storage.loadPlayerData(player.getUniqueId()).thenAccept(userData -> {
            if (userData == null) {
                player.sendMessage(this.getMsg("commands.login.not_registered"));
                return;
            }
            if (BCrypt.checkpw(args[0], userData.getHashedPassword())) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> this.handleSuccessfulLogin(player, (UserData)userData));
            } else {
                this.logManager.logFailedLogin(player.getName(), player.getAddress().getAddress().getHostAddress());
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    player.sendMessage(this.getMsg("commands.login.wrong_password"));
                    this.sendTitle(player, "incorrect-password");
                });
            }
        });
    }

    private void handleSuccessfulLogin(Player player, UserData userData) {
        String playerIP = player.getAddress().getAddress().getHostAddress();
        if (this.emailManager.isEnabled() && userData != null && userData.getEmail() != null && !userData.getEmail().isEmpty() && !playerIP.equals(userData.getLastIp())) {
            if (this.pending2FACodes.containsKey(player.getUniqueId())) {
                player.sendMessage(this.getMsg("commands.email.verification_already_pending"));
                return;
            }
            String code = this.emailManager.generateVerificationCode();
            this.pending2FACodes.put(player.getUniqueId(), code);
            this.emailManager.sendVerificationEmail(userData.getEmail(), code).thenAccept(success -> Bukkit.getScheduler().runTask((Plugin)this, () -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.getMsg("commands.email.verification_required"));
                } else {
                    player.kickPlayer("Hubo un error al enviar tu c\u00f3digo de verificaci\u00f3n. Contacta a un admin.");
                }
            }));
            return;
        }
        this.finalizeLogin(player, userData);
    }

    private void handleChangePassword(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(this.getMsg("commands.changepass.usage"));
            return;
        }
        String oldPassword = args[0];
        String newPassword = args[1];
        this.storage.loadPlayerData(player.getUniqueId()).thenAccept(userData -> {
            if (userData == null || !BCrypt.checkpw(oldPassword, userData.getHashedPassword())) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("commands.changepass.old_password_incorrect")));
                return;
            }
            if (this.getConfig().getBoolean("passwords.strength-meter.enabled", true)) {
                PasswordStrength strength = this.checkPasswordStrength(newPassword);
                if (this.getConfig().getBoolean("passwords.strength-meter.prevent-weak-passwords", true) && strength == PasswordStrength.WEAK) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("security.cannot_use_weak_password")));
                    return;
                }
            }
            String newHashedPassword = BCrypt.hashpw(newPassword, BCrypt.gensalt());
            userData.setHashedPassword(newHashedPassword);
            this.storage.savePlayerData(player, (UserData)userData);
            Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("commands.changepass.success")));
        });
    }

    private void handlePremium(Player player, String[] args) {
        UUID uuid = player.getUniqueId();
        if (args.length > 0 && args[0].equalsIgnoreCase("confirm")) {
            if (!this.premiumConfirmations.containsKey(uuid)) {
                player.sendMessage(this.getMsg("commands.premium.no_request"));
                return;
            }
            this.premiumConfirmations.remove(uuid);
            this.storage.loadPlayerData(uuid).thenAccept(userData -> {
                if (userData == null) {
                    return;
                }
                if (userData.isPremium()) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("commands.premium.already_premium")));
                    return;
                }
                if (!Bukkit.getOnlineMode()) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("commands.premium.not_available_on_offline_server")));
                    return;
                }
                userData.setPremium(true);
                this.storage.savePlayerData(player, (UserData)userData);
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("commands.premium.success")));
            });
        } else {
            this.storage.loadPlayerData(uuid).thenAccept(userData -> Bukkit.getScheduler().runTask((Plugin)this, () -> {
                if (userData != null && userData.isPremium()) {
                    player.sendMessage(this.getMsg("commands.premium.already_premium"));
                } else {
                    this.premiumConfirmations.put(uuid, true);
                    player.sendMessage(this.getMsg("commands.premium.confirm_request"));
                }
            }));
        }
    }

    private void handleUnregister(Player player, String[] args) {
        if (args.length != 1) {
            player.sendMessage(this.getMsg("commands.unregister.usage"));
            return;
        }
        String password = args[0];
        this.storage.loadPlayerData(player.getUniqueId()).thenAccept(userData -> {
            if (userData == null || !BCrypt.checkpw(password, userData.getHashedPassword())) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("commands.unregister.password_incorrect")));
                return;
            }
            if (userData.isPremium()) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.getMsg("commands.unregister.is_premium_error")));
                return;
            }
            this.storage.deletePlayerData(player.getUniqueId());
            this.logManager.logAdminAction("SISTEMA", "El jugador " + player.getName() + " se ha desregistrado.");
            Bukkit.getScheduler().runTask((Plugin)this, () -> player.kickPlayer(this.getMsg("commands.unregister.success_kick")));
        });
    }

    public void verify2FACode(Player player, String code) {
        String correctCode = this.pending2FACodes.get(player.getUniqueId());
        if (correctCode != null && correctCode.equals(code)) {
            this.pending2FACodes.remove(player.getUniqueId());
            player.sendMessage(this.getMsg("commands.email.login_after_verify"));
            this.storage.loadPlayerData(player.getUniqueId()).thenAccept(userData -> Bukkit.getScheduler().runTask((Plugin)this, () -> this.finalizeLogin(player, (UserData)userData)));
        } else {
            player.sendMessage(this.getMsg("commands.email.incorrect_code"));
        }
    }

    public void finalizeLogin(Player player, UserData userData) {
        this.logManager.logLogin(player.getName(), player.getAddress().getAddress().getHostAddress());
        this.loggedInPlayers.put(player.getUniqueId(), true);
        if (this.timeoutTasks.containsKey(player.getUniqueId())) {
            this.timeoutTasks.remove(player.getUniqueId()).cancel();
        }
        if (userData != null) {
            userData.setLastIp(player.getAddress().getAddress().getHostAddress());
            this.storage.savePlayerData(player, userData);
        }
        player.removePotionEffect(PotionEffectType.BLINDNESS);
        this.sendTitle(player, "after-login");
        if (this.getConfig().getBoolean("proxy-redirect.enabled")) {
            String server = this.getConfig().getString("proxy-redirect.target-server");
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.sendToServer(player, server), 20L);
        }
    }

    public boolean isPlayerPending2FA(UUID uuid) {
        return this.pending2FACodes.containsKey(uuid);
    }

    public void handleDelAcc(CommandSender sender, String targetName) {
    }

    public void sendToServer(Player player, String serverName) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(serverName);
        player.sendPluginMessage((Plugin)this, "BungeeCord", out.toByteArray());
    }

    private void startLoginTimeout(Player player) {
        if (this.getConfig().getBoolean("security.time-to-login.enabled")) {
            int duration = this.getConfig().getInt("security.time-to-login.duration-seconds", 60);
            BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (player.isOnline() && !this.loggedInPlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                    player.kickPlayer(this.getMsg("commands.login.timeout_kick"));
                }
            }, (long)duration * 20L);
            this.timeoutTasks.put(player.getUniqueId(), task);
        }
    }

    private void sendTitle(Player player, String configPath) {
        ConfigurationSection titleSection = this.getConfig().getConfigurationSection("ui.titles." + configPath);
        if (titleSection == null) {
            return;
        }
        String title = this.translateHexColorCodes(titleSection.getString("title", ""));
        String subtitle = this.translateHexColorCodes(titleSection.getString("subtitle", ""));
        int fadeIn = titleSection.getInt("fade-in", 10);
        int stay = titleSection.getInt("stay", 70);
        int fadeOut = titleSection.getInt("fade-out", 20);
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public String translateHexColorCodes(String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(buffer).toString());
    }

    private PasswordStrength checkPasswordStrength(String password) {
        int score = 0;
        if (password.length() > 8) {
            ++score;
        }
        if (password.length() > 12) {
            ++score;
        }
        if (password.matches(".*\\d.*")) {
            ++score;
        }
        if (password.matches(".*[a-z].*") && password.matches(".*[A-Z].*")) {
            ++score;
        }
        if (password.matches(".*[!@#$%^&*?_.,()].*")) {
            ++score;
        }
        switch (score) {
            case 0: 
            case 1: {
                return PasswordStrength.WEAK;
            }
            case 2: {
                return PasswordStrength.MEDIUM;
            }
            case 3: 
            case 4: {
                return PasswordStrength.STRONG;
            }
            case 5: {
                return PasswordStrength.VERY_STRONG;
            }
        }
        return PasswordStrength.WEAK;
    }

    private String getStrengthAsBar(PasswordStrength strength) {
        switch (strength) {
            case WEAK: {
                return this.getMsg("security.password_weak");
            }
            case MEDIUM: {
                return this.getMsg("security.password_medium");
            }
            case STRONG: {
                return this.getMsg("security.password_strong");
            }
            case VERY_STRONG: {
                return this.getMsg("security.password_very_strong");
            }
        }
        return "";
    }

    public static class UserData {
        private String hashedPassword;
        private String lastIp;
        private boolean isPremium;
        private String email;

        public UserData(String hashedPassword, String lastIp, boolean isPremium, String email) {
            this.hashedPassword = hashedPassword;
            this.lastIp = lastIp;
            this.isPremium = isPremium;
            this.email = email;
        }

        public String getHashedPassword() {
            return this.hashedPassword;
        }

        public String getLastIp() {
            return this.lastIp;
        }

        public boolean isPremium() {
            return this.isPremium;
        }

        public String getEmail() {
            return this.email;
        }

        public void setHashedPassword(String hashedPassword) {
            this.hashedPassword = hashedPassword;
        }

        public void setLastIp(String lastIp) {
            this.lastIp = lastIp;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setPremium(boolean isPremium) {
            this.isPremium = isPremium;
        }
    }

    public static class SessionData {
        private final String ipAddress;
        private final Instant expiryTime;

        public SessionData(String ipAddress, long timeoutMinutes) {
            this.ipAddress = ipAddress;
            this.expiryTime = Instant.now().plusSeconds(timeoutMinutes * 60L);
        }

        public boolean isValid(String currentIp) {
            return this.ipAddress.equals(currentIp) && Instant.now().isBefore(this.expiryTime);
        }
    }

    private static enum PasswordStrength {
        WEAK,
        MEDIUM,
        STRONG,
        VERY_STRONG;

    }

    public static class IpData {
        private int registrationCount;
        private boolean isBlocked;

        public IpData(int registrationCount, boolean isBlocked) {
            this.registrationCount = registrationCount;
            this.isBlocked = isBlocked;
        }

        public int getRegistrationCount() {
            return this.registrationCount;
        }

        public boolean isBlocked() {
            return this.isBlocked;
        }

        public void setBlocked(boolean blocked) {
            this.isBlocked = blocked;
        }

        public void incrementRegistrationCount() {
            ++this.registrationCount;
        }
    }
}

