/*
 * Decompiled with CFR 0.152.
 */
package willfrydev.commands;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mindrot.jbcrypt.BCrypt;
import willfrydev.LoginTo;
import willfrydev.manager.EmailManager;

public class EmailCommand
implements CommandExecutor {
    private final LoginTo plugin;
    private final EmailManager emailManager;
    private final Map<UUID, String> pendingLinkVerification = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, String> pendingRecovery = new ConcurrentHashMap<UUID, String>();
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,6}$");

    public EmailCommand(LoginTo plugin, EmailManager emailManager) {
        this.plugin = plugin;
        this.emailManager = emailManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.emailManager.isEnabled()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "El sistema de email est\u00e1 desactivado.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usa: /email <add|verify|recover>");
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("recover")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Este comando solo para jugadores.");
                return true;
            }
            this.handleRecover((Player)sender, args);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Este comando solo para jugadores.");
            return true;
        }
        Player player = (Player)sender;
        if (subCommand.equals("add")) {
            this.handleAddEmail(player, args);
        } else if (subCommand.equals("verify")) {
            this.handleVerify(player, args);
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usa: /email <add|verify|recover>");
        }
        return true;
    }

    private void handleAddEmail(Player player, String[] args) {
        if (!this.plugin.getLoggedInPlayers().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            player.sendMessage(this.plugin.getMsg("login_prompt"));
            return;
        }
        if (args.length != 2) {
            player.sendMessage(this.plugin.getMsg("email.usage_add"));
            return;
        }
        String email = args[1];
        if (!EMAIL_PATTERN.matcher(email).matches()) {
            player.sendMessage(this.plugin.getMsg("email.invalid_email_format"));
            return;
        }
        this.plugin.getStorage().loadPlayerData(player.getUniqueId()).thenAccept(userData -> {
            if (userData != null && userData.getEmail() != null && !userData.getEmail().isEmpty()) {
                player.sendMessage(this.plugin.getMsg("email.email_already_linked"));
                return;
            }
            String code = this.emailManager.generateVerificationCode();
            this.pendingLinkVerification.put(player.getUniqueId(), email + ":" + code);
            this.emailManager.sendVerificationEmail(email, code).thenAccept(success -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.plugin.getMsg("email.verification_code_sent"));
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Hubo un error al enviar el correo. Revisa la configuraci\u00f3n y la consola.");
                }
            }));
        });
    }

    private void handleVerify(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(this.plugin.getMsg("email.usage_verify"));
            return;
        }
        UUID uuid = player.getUniqueId();
        String code = args[1];
        if (this.plugin.isPlayerPending2FA(uuid)) {
            this.plugin.verify2FACode(player, code);
            return;
        }
        String pending = this.pendingLinkVerification.get(uuid);
        if (pending != null) {
            String[] parts = pending.split(":");
            String email = parts[0];
            String correctCode = parts[1];
            if (code.equals(correctCode)) {
                this.pendingLinkVerification.remove(uuid);
                this.plugin.getStorage().loadPlayerData(uuid).thenAccept(userData -> {
                    if (userData != null) {
                        userData.setEmail(email);
                        this.plugin.getStorage().savePlayerData(player, (LoginTo.UserData)userData);
                        player.sendMessage(this.plugin.getMsg("email.email_link_success"));
                    }
                });
            } else {
                player.sendMessage(this.plugin.getMsg("email.incorrect_code"));
            }
        } else {
            player.sendMessage(this.plugin.getMsg("email.incorrect_code"));
        }
    }

    private void handleRecover(Player player, String[] args) {
        UUID uuid = player.getUniqueId();
        if (args.length == 1) {
            this.plugin.getStorage().loadPlayerData(uuid).thenAccept(userData -> {
                if (userData == null || userData.getEmail() == null || userData.getEmail().isEmpty()) {
                    player.sendMessage(this.plugin.getMsg("email.recover_email_not_linked"));
                    return;
                }
                String code = this.emailManager.generateVerificationCode();
                this.pendingRecovery.put(uuid, code);
                this.emailManager.sendRecoveryEmail(userData.getEmail(), code).thenAccept(success -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.plugin.getMsg("email.recover_instructions_sent"));
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Hubo un error al enviar el correo. Revisa la configuraci\u00f3n y la consola.");
                    }
                }));
            });
        } else if (args.length == 3) {
            String newPassword = args[1];
            String code = args[2];
            String correctCode = this.pendingRecovery.get(uuid);
            if (correctCode != null && correctCode.equals(code)) {
                this.pendingRecovery.remove(uuid);
                this.plugin.getStorage().loadPlayerData(uuid).thenAccept(userData -> {
                    if (userData != null) {
                        String hashedPassword = BCrypt.hashpw(newPassword, BCrypt.gensalt());
                        userData.setHashedPassword(hashedPassword);
                        this.plugin.getStorage().savePlayerData(player, (LoginTo.UserData)userData);
                        player.sendMessage(this.plugin.getMsg("email.recover_success"));
                    }
                });
            } else {
                player.sendMessage(this.plugin.getMsg("email.incorrect_code"));
            }
        } else {
            player.sendMessage(this.plugin.getMsg("email.recover_command_usage"));
        }
    }
}

