/*
 * Decompiled with CFR 0.152.
 */
package willfrydev.manager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import willfrydev.LoginTo;

public class LogManager {
    private final LoginTo plugin;
    private final File logFile;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public LogManager(LoginTo plugin) {
        this.plugin = plugin;
        File logsFolder = new File(plugin.getDataFolder(), "logs");
        if (!logsFolder.exists()) {
            logsFolder.mkdirs();
        }
        this.logFile = new File(logsFolder, "security.log");
    }

    public void log(String message) {
        if (!this.plugin.getConfig().getBoolean("logging.enabled", true)) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.logFile, true));){
                String timestamp = this.dateFormat.format(new Date());
                writer.write("[" + timestamp + "] " + message);
                writer.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void logRegistration(String playerName, String ip) {
        if (this.plugin.getConfig().getBoolean("logging.log-registrations", true)) {
            this.log("REGISTRO: El jugador " + playerName + " se ha registrado desde la IP " + ip);
        }
    }

    public void logLogin(String playerName, String ip) {
        if (this.plugin.getConfig().getBoolean("logging.log-successful-logins", true)) {
            this.log("LOGIN: El jugador " + playerName + " ha iniciado sesi\u00f3n desde la IP " + ip);
        }
    }

    public void logFailedLogin(String playerName, String ip) {
        if (this.plugin.getConfig().getBoolean("logging.log-failed-attempts", true)) {
            this.log("FALLO DE LOGIN: Intento fallido para el jugador " + playerName + " desde la IP " + ip);
        }
    }

    public void logAdminAction(String adminName, String action) {
        if (this.plugin.getConfig().getBoolean("logging.log-admin-actions", true)) {
            this.log("ACCI\u00d3N DE ADMIN: " + adminName + " ejecut\u00f3 la siguiente acci\u00f3n: " + action);
        }
    }
}

