/*
 * Decompiled with CFR 0.152.
 */
package willfrydev.manager;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import willfrydev.LoginTo;
import willfrydev.dbs.Storage;

public class MySQLManager
implements Storage {
    private final LoginTo plugin;
    private HikariDataSource dataSource;

    public MySQLManager(LoginTo plugin) {
        this.plugin = plugin;
    }

    @Override
    public void connect() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().severe("\u00a1CR\u00cdTICO! El driver de MySQL no fue encontrado. El plugin no puede iniciar.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return;
        }
        ConfigurationSection dbConfig = this.plugin.getConfig().getConfigurationSection("storage.mysql");
        if (dbConfig == null) {
            this.plugin.getLogger().severe("\u00a1La secci\u00f3n de configuraci\u00f3n de MySQL no existe en config.yml!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return;
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + dbConfig.getString("hostname") + ":" + dbConfig.getInt("port") + "/" + dbConfig.getString("database"));
        config.setUsername(dbConfig.getString("username"));
        config.setPassword(dbConfig.getString("password"));
        config.setMaximumPoolSize(dbConfig.getInt("pool-settings.maximum-pool-size", 10));
        config.setConnectionTimeout(dbConfig.getInt("pool-settings.connection-timeout", 5000));
        ConfigurationSection properties = dbConfig.getConfigurationSection("properties");
        if (properties != null) {
            properties.getValues(false).forEach(config::addDataSourceProperty);
        }
        this.dataSource = new HikariDataSource(config);
        this.plugin.getLogger().info("Conexi\u00f3n con la base de datos MySQL establecida.");
        this.setupTables();
    }

    private void setupTables() {
        String playersTableSql = "CREATE TABLE IF NOT EXISTS player_data (uuid VARCHAR(36) NOT NULL UNIQUE PRIMARY KEY,username VARCHAR(16) NOT NULL,hashed_password TEXT NOT NULL,last_ip VARCHAR(45),is_premium BOOLEAN DEFAULT FALSE,email VARCHAR(255) DEFAULT NULL,registration_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP);";
        String ipTableSql = "CREATE TABLE IF NOT EXISTS ip_data (ip_address VARCHAR(45) NOT NULL UNIQUE PRIMARY KEY,registration_count INT DEFAULT 0,is_blocked BOOLEAN DEFAULT FALSE);";
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement(playersTableSql);){
                statement.execute();
            }
            statement = connection.prepareStatement(ipTableSql);
            try {
                statement.execute();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("No se pudo crear una de las tablas en la base de datos: " + e.getMessage());
        }
    }

    @Override
    public CompletableFuture<LoginTo.UserData> loadPlayerData(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT * FROM player_data WHERE uuid = ?");){
                statement.setString(1, uuid.toString());
                ResultSet rs = statement.executeQuery();
                if (!rs.next()) return null;
                LoginTo.UserData userData = new LoginTo.UserData(rs.getString("hashed_password"), rs.getString("last_ip"), rs.getBoolean("is_premium"), rs.getString("email"));
                return userData;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    @Override
    public void savePlayerData(Player player, LoginTo.UserData data) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String sql = "INSERT INTO player_data (uuid, username, hashed_password, last_ip, is_premium, email) VALUES (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE username = ?, hashed_password = ?, last_ip = ?, is_premium = ?, email = ?;";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, player.getUniqueId().toString());
                statement.setString(2, player.getName());
                statement.setString(3, data.getHashedPassword());
                statement.setString(4, data.getLastIp());
                statement.setBoolean(5, data.isPremium());
                statement.setString(6, data.getEmail());
                statement.setString(7, player.getName());
                statement.setString(8, data.getHashedPassword());
                statement.setString(9, data.getLastIp());
                statement.setBoolean(10, data.isPremium());
                statement.setString(11, data.getEmail());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<LoginTo.IpData> loadIpData(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT * FROM ip_data WHERE ip_address = ?");){
                statement.setString(1, ipAddress);
                ResultSet rs = statement.executeQuery();
                if (!rs.next()) return new LoginTo.IpData(0, false);
                LoginTo.IpData ipData = new LoginTo.IpData(rs.getInt("registration_count"), rs.getBoolean("is_blocked"));
                return ipData;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return new LoginTo.IpData(0, false);
        });
    }

    @Override
    public void saveIpData(String ipAddress, LoginTo.IpData ipData) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String sql = "INSERT INTO ip_data (ip_address, registration_count, is_blocked) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE registration_count = ?, is_blocked = ?;";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, ipAddress);
                statement.setInt(2, ipData.getRegistrationCount());
                statement.setBoolean(3, ipData.isBlocked());
                statement.setInt(4, ipData.getRegistrationCount());
                statement.setBoolean(5, ipData.isBlocked());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<List<Map<String, String>>> getPlayerList(int offset, int limit) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList players = new ArrayList();
            String sql = "SELECT username, uuid FROM player_data ORDER BY username ASC LIMIT ? OFFSET ?;";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, limit);
                statement.setInt(2, offset);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    HashMap<String, String> playerData = new HashMap<String, String>();
                    playerData.put("username", rs.getString("username"));
                    playerData.put("uuid", rs.getString("uuid"));
                    players.add(playerData);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return players;
        });
    }

    @Override
    public CompletableFuture<Integer> getTotalPlayerCount() {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT COUNT(uuid) FROM player_data;";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);
                 ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return 0;
                Integer n = rs.getInt(1);
                return n;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return 0;
        });
    }

    @Override
    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }
}

