/*
 * Decompiled with CFR 0.152.
 */
package net.alexis.simple_zoom.core;

public class ZoomAnimationHandler {
    private float zoomProgress = 0.0f;
    private float smoothedZoomProgress = 0.0f;
    private long lastUpdateTime = System.currentTimeMillis();
    private static final float SMOOTH_TIME = 0.15f;
    private boolean targetZoomState = false;

    public void updateAnimation(boolean isZooming) {
        float targetProgress;
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
        this.lastUpdateTime = currentTime;
        deltaTime = Math.min(deltaTime, 0.1f);
        this.targetZoomState = isZooming;
        float f = targetProgress = this.targetZoomState ? 1.0f : 0.0f;
        if (this.zoomProgress != targetProgress) {
            float progressDiff = targetProgress - this.zoomProgress;
            float direction = Math.signum(progressDiff);
            float baseSpeed = 6.6666665f;
            float adaptiveSpeed = baseSpeed * Math.abs(progressDiff) * 2.0f;
            float transition = adaptiveSpeed * deltaTime;
            this.zoomProgress = Math.abs(progressDiff) <= transition ? targetProgress : (this.zoomProgress += direction * transition);
            this.zoomProgress = Math.max(0.0f, Math.min(1.0f, this.zoomProgress));
        }
        this.smoothedZoomProgress = this.lowPassFilter(this.smoothedZoomProgress, this.zoomProgress, deltaTime);
    }

    private float lowPassFilter(float current, float target, float deltaTime) {
        float alpha = 1.0f - (float)Math.exp(-deltaTime / 0.15f);
        return current + (target - current) * alpha;
    }

    public float getSmoothedZoomProgress() {
        return this.smoothedZoomProgress;
    }
}

