/*
 * Decompiled with CFR 0.152.
 */
package net.alexis.simple_zoom.core;

import net.alexis.simple_zoom.core.KeybindHandler;
import net.alexis.simple_zoom.core.ZoomAnimationHandler;
import net.alexis.simple_zoom.core.ZoomStateHandler;
import net.minecraft.class_1600;

public class ZoomManager {
    private KeybindHandler keybindHandler;
    private ZoomStateHandler zoomStateHandler;
    private ZoomAnimationHandler zoomAnimationHandler;
    private float originalFov = 70.0f;
    private boolean hasStoredOriginalFov = false;
    private float lastProgress = -1.0f;
    private static final float UPDATE_THRESHOLD = 0.01f;
    private long lastUpdateTime = 0L;

    public void initialize() {
        this.keybindHandler = new KeybindHandler();
        this.zoomStateHandler = new ZoomStateHandler();
        this.zoomAnimationHandler = new ZoomAnimationHandler();
        this.keybindHandler.initialize();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void onClientTick() {
        boolean isInGui = this.keybindHandler.isInGui();
        boolean zoomKeyPressed = this.keybindHandler.isZoomKeyPressed();
        this.zoomStateHandler.updateState(zoomKeyPressed, isInGui);
    }

    public void onRenderTick() {
        this.zoomAnimationHandler.updateAnimation(this.zoomStateHandler.isZooming());
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime >= 16L) {
            this.updateGameFov();
            this.lastUpdateTime = currentTime;
        }
    }

    private void updateGameFov() {
        float currentProgress = this.getZoomProgress();
        if (Math.abs(currentProgress - this.lastProgress) > 0.01f || currentProgress == 0.0f || currentProgress == 1.0f) {
            try {
                class_1600 mc = class_1600.method_2965();
                if (mc != null && mc.field_3823 != null) {
                    if (!this.hasStoredOriginalFov && currentProgress > 0.0f) {
                        this.originalFov = mc.field_3823.field_958;
                        this.hasStoredOriginalFov = true;
                    }
                    if (currentProgress > 0.0f) {
                        mc.field_3823.field_958 = this.getZoomedFov(this.originalFov);
                    } else if (this.hasStoredOriginalFov) {
                        mc.field_3823.field_958 = this.originalFov;
                        this.hasStoredOriginalFov = false;
                    }
                    this.lastProgress = currentProgress;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public float getZoomedFov(float originalFov) {
        float progress = this.zoomAnimationHandler.getSmoothedZoomProgress();
        if (progress > 0.0f) {
            float zoomedFov = this.calculateZoomedFov(originalFov);
            return this.interpolateFovSmooth(originalFov, zoomedFov, progress);
        }
        return originalFov;
    }

    private float calculateZoomedFov(float originalFov) {
        float ZOOM_MULTIPLIER = 4.0f;
        float MIN_ZOOM_FOV = 10.0f;
        float zoomedFov = originalFov / 4.0f;
        return Math.max(10.0f, zoomedFov);
    }

    private float interpolateFovSmooth(float start, float end, float progress) {
        if (progress <= 0.0f) {
            return start;
        }
        if (progress >= 1.0f) {
            return end;
        }
        float easedProgress = this.quinticEaseInOut(progress);
        return start + (end - start) * easedProgress;
    }

    private float quinticEaseInOut(float t) {
        if (t < 0.5f) {
            return 16.0f * t * t * t * t * t;
        }
        float f = 2.0f * t - 2.0f;
        return 0.5f * f * f * f * f * f + 1.0f;
    }

    public float getZoomProgress() {
        return this.zoomAnimationHandler.getSmoothedZoomProgress();
    }
}

