/*
 * Decompiled with CFR 0.152.
 */
package net.alexis.simple_zoom;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class SimpleZoom
implements ClientModInitializer {
    private static boolean currentlyZoomed;
    private static class_304 zoomKey;
    public static final double ZOOM_LEVEL = 0.1;
    private static long animationStartTime;
    private static final long ANIMATION_DURATION = 200L;
    private static double currentZoomFactor;

    public void onInitializeClient() {
        zoomKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.simple_zoom.zoom", class_3675.class_307.field_1668, 67, class_304.class_11900.field_62556));
    }

    public static boolean isZooming() {
        return zoomKey.method_1434();
    }

    public static double getCurrentZoomLevel() {
        return currentZoomFactor;
    }

    public static void manageSmoothCamera() {
        boolean zooming = SimpleZoom.isZooming();
        if (zooming && !currentlyZoomed) {
            currentlyZoomed = true;
            animationStartTime = System.currentTimeMillis();
        } else if (!zooming && currentlyZoomed) {
            currentlyZoomed = false;
            animationStartTime = System.currentTimeMillis();
        }
        SimpleZoom.updateZoomAnimation();
    }

    private static void updateZoomAnimation() {
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - animationStartTime;
        if (elapsed < 200L) {
            double progress = (double)elapsed / 200.0;
            double easeOut = 1.0 - Math.pow(1.0 - progress, 2.0);
            currentZoomFactor = currentlyZoomed ? 1.0 + -0.9 * easeOut : 0.1 + 0.9 * easeOut;
        } else {
            currentZoomFactor = currentlyZoomed ? 0.1 : 1.0;
        }
    }

    static {
        animationStartTime = 0L;
        currentZoomFactor = 1.0;
    }
}

