/*
 * Decompiled with CFR 0.152.
 */
package com.treecutter;

import com.treecutter.commands.TreeCutterAdminCommand;
import com.treecutter.commands.TreeCutterCommand;
import com.treecutter.listeners.TreeCutterListener;
import com.treecutter.managers.PlayerDataManager;
import com.treecutter.utils.TreeDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TreeCutterPlugin
extends JavaPlugin {
    private static TreeCutterPlugin instance;
    private PlayerDataManager playerDataManager;
    private TreeDetector treeDetector;
    private Map<UUID, Long> playerCooldowns;
    private boolean pluginEnabled;
    private int maxLogsPerTree;
    private int minLogsForTree;
    private int maxSearchDistance;
    private boolean dropAtPlayer;
    private boolean debugMode;
    private int cutDelay;
    private boolean asyncProcessing;
    private boolean cacheTrees;
    private int cacheDuration;

    public void onEnable() {
        instance = this;
        this.playerCooldowns = new HashMap<UUID, Long>();
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.playerDataManager = new PlayerDataManager(this);
        this.treeDetector = new TreeDetector(this);
        this.getServer().getPluginManager().registerEvents((Listener)new TreeCutterListener(this), (Plugin)this);
        TreeCutterCommand playerCommand = new TreeCutterCommand(this);
        this.getCommand("treecutter").setExecutor((CommandExecutor)playerCommand);
        this.getCommand("treecutter").setTabCompleter((TabCompleter)playerCommand);
        this.getCommand("tc").setExecutor((CommandExecutor)playerCommand);
        this.getCommand("tc").setTabCompleter((TabCompleter)playerCommand);
        TreeCutterAdminCommand adminCommand = new TreeCutterAdminCommand(this);
        this.getCommand("treecutteradmin").setExecutor((CommandExecutor)adminCommand);
        this.getCommand("treecutteradmin").setTabCompleter((TabCompleter)adminCommand);
        this.startCleanupTask();
        this.getLogger().info("TreeCutter plugin has been enabled!");
        if (this.debugMode) {
            this.getLogger().info("Debug mode is enabled - additional logging will be shown");
        }
    }

    public void onDisable() {
        if (this.playerDataManager != null) {
            this.playerDataManager.saveAllPlayerData();
        }
        if (this.playerCooldowns != null) {
            this.playerCooldowns.clear();
        }
        this.getLogger().info("TreeCutter plugin has been disabled!");
        instance = null;
    }

    public void loadConfiguration() {
        this.reloadConfig();
        this.pluginEnabled = this.getConfig().getBoolean("settings.enabled", true);
        this.maxLogsPerTree = this.getConfig().getInt("settings.max-logs-per-tree", 128);
        this.minLogsForTree = this.getConfig().getInt("settings.min-logs-for-tree", 3);
        this.maxSearchDistance = this.getConfig().getInt("settings.max-search-distance", 32);
        this.dropAtPlayer = this.getConfig().getBoolean("settings.drop-at-player", false);
        this.debugMode = this.getConfig().getBoolean("settings.debug", false);
        this.cutDelay = this.getConfig().getInt("performance.cut-delay", 5);
        this.asyncProcessing = this.getConfig().getBoolean("performance.async-processing", false);
        this.cacheTrees = this.getConfig().getBoolean("performance.cache-trees", true);
        this.cacheDuration = this.getConfig().getInt("performance.cache-duration", 30);
        if (this.debugMode) {
            this.getLogger().info("Configuration loaded - Plugin enabled: " + this.pluginEnabled);
        }
    }

    private void startCleanupTask() {
        new BukkitRunnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                TreeCutterPlugin.this.playerCooldowns.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > (long)TreeCutterPlugin.this.cutDelay * 50L);
            }
        }.runTaskTimerAsynchronously((Plugin)this, 1200L, 1200L);
    }

    public boolean isPlayerOnCooldown(UUID playerId) {
        long cooldownTime;
        if (!this.playerCooldowns.containsKey(playerId)) {
            return false;
        }
        long lastCut = this.playerCooldowns.get(playerId);
        long currentTime = System.currentTimeMillis();
        return currentTime - lastCut < (cooldownTime = (long)this.cutDelay * 50L);
    }

    public void setPlayerCooldown(UUID playerId) {
        this.playerCooldowns.put(playerId, System.currentTimeMillis());
    }

    public String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String key) {
        String message = this.getConfig().getString("messages." + key, "&cMessage not found: " + key);
        String prefix = this.getConfig().getString("messages.prefix", "&f[&6TreeCutter&f]");
        message = message.replace("%prefix%", prefix);
        return this.colorize(message);
    }

    public String getMessage(String key, String ... replacements) {
        String message = this.getMessage(key);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            message = message.replace(replacements[i], replacements[i + 1]);
        }
        return message;
    }

    public void debugLog(String message) {
        if (this.debugMode) {
            this.getLogger().log(Level.INFO, "[DEBUG] " + message);
        }
    }

    public static TreeCutterPlugin getInstance() {
        return instance;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public TreeDetector getTreeDetector() {
        return this.treeDetector;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public int getMaxLogsPerTree() {
        return this.maxLogsPerTree;
    }

    public int getMinLogsForTree() {
        return this.minLogsForTree;
    }

    public int getMaxSearchDistance() {
        return this.maxSearchDistance;
    }

    public boolean shouldDropAtPlayer() {
        return this.dropAtPlayer;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public int getCutDelay() {
        return this.cutDelay;
    }

    public boolean isAsyncProcessingEnabled() {
        return this.asyncProcessing;
    }

    public boolean isCacheTreesEnabled() {
        return this.cacheTrees;
    }

    public int getCacheDuration() {
        return this.cacheDuration;
    }
}

