/*
 * Decompiled with CFR 0.152.
 */
package com.treecutter.commands;

import com.treecutter.TreeCutterPlugin;
import com.treecutter.managers.PlayerDataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TreeCutterAdminCommand
implements CommandExecutor,
TabCompleter {
    private final TreeCutterPlugin plugin;

    public TreeCutterAdminCommand(TreeCutterPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("treecutter.admin")) {
            sender.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.no-permission", "&c[TreeCutter] You don't have permission to use this command!")));
            return true;
        }
        if (args.length == 0) {
            return this.handleHelp(sender);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "config": 
            case "settings": {
                return this.handleConfig(sender);
            }
            case "info": 
            case "status": {
                return this.handleInfo(sender);
            }
            case "player": {
                return this.handlePlayer(sender, args);
            }
            case "cache": {
                return this.handleCache(sender, args);
            }
            case "cleanup": {
                return this.handleCleanup(sender);
            }
            case "debug": {
                return this.handleDebug(sender, args);
            }
            case "help": {
                return this.handleHelp(sender);
            }
        }
        return this.handleInvalidUsage(sender);
    }

    private boolean handleReload(CommandSender sender) {
        try {
            this.plugin.loadConfiguration();
            sender.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.config-reloaded", "&a[TreeCutter] Configuration reloaded successfully!")));
            this.plugin.getLogger().info("Configuration reloaded by " + sender.getName());
            return true;
        }
        catch (Exception e) {
            sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Error reloading configuration: " + e.getMessage()));
            this.plugin.getLogger().warning("Error reloading configuration: " + e.getMessage());
            return true;
        }
    }

    private boolean handleConfig(CommandSender sender) {
        sender.sendMessage(this.plugin.colorize("&6=== TreeCutter Configuration ==="));
        sender.sendMessage(this.plugin.colorize("&7Plugin Enabled: " + (this.plugin.isPluginEnabled() ? "&aYes" : "&cNo")));
        sender.sendMessage(this.plugin.colorize("&7Max Logs Per Tree: &e" + this.plugin.getMaxLogsPerTree()));
        sender.sendMessage(this.plugin.colorize("&7Min Logs For Tree: &e" + this.plugin.getMinLogsForTree()));
        sender.sendMessage(this.plugin.colorize("&7Max Search Distance: &e" + this.plugin.getMaxSearchDistance()));
        sender.sendMessage(this.plugin.colorize("&7Drop At Player: " + (this.plugin.shouldDropAtPlayer() ? "&aYes" : "&cNo")));
        sender.sendMessage(this.plugin.colorize("&7Debug Mode: " + (this.plugin.isDebugMode() ? "&aYes" : "&cNo")));
        sender.sendMessage(this.plugin.colorize("&7Cut Delay: &e" + this.plugin.getCutDelay() + " ticks"));
        sender.sendMessage(this.plugin.colorize("&7Async Processing: " + (this.plugin.isAsyncProcessingEnabled() ? "&aYes" : "&cNo")));
        sender.sendMessage(this.plugin.colorize("&7Cache Trees: " + (this.plugin.isCacheTreesEnabled() ? "&aYes" : "&cNo")));
        if (this.plugin.isCacheTreesEnabled()) {
            sender.sendMessage(this.plugin.colorize("&7Cache Duration: &e" + this.plugin.getCacheDuration() + " seconds"));
            sender.sendMessage(this.plugin.colorize("&7Current Cache Size: &e" + this.plugin.getTreeDetector().getCacheSize()));
        }
        return true;
    }

    private boolean handleInfo(CommandSender sender) {
        Map<UUID, PlayerDataManager.PlayerData> allData = this.plugin.getPlayerDataManager().getAllPlayerData();
        int totalPlayers = allData.size();
        int enabledPlayers = (int)allData.values().stream().mapToLong(data -> data.isTreeCuttingEnabled() ? 1L : 0L).sum();
        sender.sendMessage(this.plugin.colorize("&6=== TreeCutter Information ==="));
        sender.sendMessage(this.plugin.colorize("&7Plugin Version: &e" + this.plugin.getDescription().getVersion()));
        sender.sendMessage(this.plugin.colorize("&7Total Players: &e" + totalPlayers));
        sender.sendMessage(this.plugin.colorize("&7Players with Tree Cutting Enabled: &e" + enabledPlayers));
        sender.sendMessage(this.plugin.colorize("&7Players with Tree Cutting Disabled: &e" + (totalPlayers - enabledPlayers)));
        if (this.plugin.isCacheTreesEnabled()) {
            sender.sendMessage(this.plugin.colorize("&7Tree Cache Size: &e" + this.plugin.getTreeDetector().getCacheSize()));
        }
        List enabledWorlds = this.plugin.getConfig().getStringList("worlds.enabled-worlds");
        List disabledWorlds = this.plugin.getConfig().getStringList("worlds.disabled-worlds");
        if (!enabledWorlds.isEmpty()) {
            sender.sendMessage(this.plugin.colorize("&7Enabled Worlds: &e" + String.join((CharSequence)", ", enabledWorlds)));
        }
        if (!disabledWorlds.isEmpty()) {
            sender.sendMessage(this.plugin.colorize("&7Disabled Worlds: &c" + String.join((CharSequence)", ", disabledWorlds)));
        }
        return true;
    }

    private boolean handlePlayer(CommandSender sender, String[] args) {
        String action;
        if (args.length < 2) {
            sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Usage: /treecutteradmin player <player> [enable|disable|info]"));
            return true;
        }
        String playerName = args[1];
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Player not found: " + playerName));
            return true;
        }
        if (args.length == 2) {
            boolean enabled = this.plugin.getPlayerDataManager().isTreeCuttingEnabled(target);
            PlayerDataManager.PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(target);
            sender.sendMessage(this.plugin.colorize("&6=== Player Info: " + target.getName() + " ==="));
            sender.sendMessage(this.plugin.colorize("&7Tree Cutting: " + (enabled ? "&aEnabled" : "&cDisabled")));
            sender.sendMessage(this.plugin.colorize("&7UUID: &e" + String.valueOf(target.getUniqueId())));
            sender.sendMessage(this.plugin.colorize("&7Current World: &e" + target.getWorld().getName()));
            sender.sendMessage(this.plugin.colorize("&7World Enabled: " + (this.plugin.getTreeDetector().isWorldEnabled(target.getWorld().getName()) ? "&aYes" : "&cNo")));
            return true;
        }
        switch (action = args[2].toLowerCase()) {
            case "enable": {
                this.plugin.getPlayerDataManager().setTreeCuttingEnabled(target, true);
                sender.sendMessage(this.plugin.colorize("&a[TreeCutter] Enabled tree cutting for " + target.getName()));
                target.sendMessage(this.plugin.colorize("&a[TreeCutter] Tree cutting has been enabled by an administrator."));
                break;
            }
            case "disable": {
                this.plugin.getPlayerDataManager().setTreeCuttingEnabled(target, false);
                sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Disabled tree cutting for " + target.getName()));
                target.sendMessage(this.plugin.colorize("&c[TreeCutter] Tree cutting has been disabled by an administrator."));
                break;
            }
            default: {
                sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Invalid action. Use: enable, disable, or info"));
            }
        }
        return true;
    }

    private boolean handleCache(CommandSender sender, String[] args) {
        if (!this.plugin.isCacheTreesEnabled()) {
            sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Tree caching is disabled in configuration."));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.colorize("&7Cache Size: &e" + this.plugin.getTreeDetector().getCacheSize()));
            sender.sendMessage(this.plugin.colorize("&7Use '/treecutteradmin cache clear' to clear the cache."));
            return true;
        }
        String action = args[1].toLowerCase();
        if ("clear".equals(action)) {
            int oldSize = this.plugin.getTreeDetector().getCacheSize();
            this.plugin.getTreeDetector().clearCache();
            sender.sendMessage(this.plugin.colorize("&a[TreeCutter] Cleared tree cache (" + oldSize + " entries removed)."));
        } else {
            sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Invalid cache action. Use 'clear'."));
        }
        return true;
    }

    private boolean handleCleanup(CommandSender sender) {
        sender.sendMessage(this.plugin.colorize("&7[TreeCutter] Starting cleanup of old player data..."));
        long thirtyDaysInMillis = 2592000000L;
        this.plugin.getPlayerDataManager().cleanupOldData(thirtyDaysInMillis);
        sender.sendMessage(this.plugin.colorize("&a[TreeCutter] Cleanup completed. Check console for details."));
        return true;
    }

    private boolean handleDebug(CommandSender sender, String[] args) {
        String action;
        if (args.length < 2) {
            boolean debugMode = this.plugin.isDebugMode();
            sender.sendMessage(this.plugin.colorize("&7Debug Mode: " + (debugMode ? "&aEnabled" : "&cDisabled")));
            sender.sendMessage(this.plugin.colorize("&7Use '/treecutteradmin debug [on|off]' to toggle."));
            return true;
        }
        switch (action = args[1].toLowerCase()) {
            case "on": 
            case "true": 
            case "enable": {
                this.plugin.getConfig().set("settings.debug", (Object)true);
                this.plugin.saveConfig();
                this.plugin.loadConfiguration();
                sender.sendMessage(this.plugin.colorize("&a[TreeCutter] Debug mode enabled."));
                break;
            }
            case "off": 
            case "false": 
            case "disable": {
                this.plugin.getConfig().set("settings.debug", (Object)false);
                this.plugin.saveConfig();
                this.plugin.loadConfiguration();
                sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Debug mode disabled."));
                break;
            }
            default: {
                sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Invalid debug action. Use 'on' or 'off'."));
            }
        }
        return true;
    }

    private boolean handleHelp(CommandSender sender) {
        sender.sendMessage(this.plugin.colorize("&6=== TreeCutter Admin Commands ==="));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin reload &7- Reload the plugin configuration"));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin config &7- View current configuration"));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin info &7- View plugin information"));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin player <name> [enable|disable] &7- Manage player settings"));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin cache [clear] &7- Manage tree cache"));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin cleanup &7- Clean up old player data"));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin debug [on|off] &7- Toggle debug mode"));
        sender.sendMessage(this.plugin.colorize("&e/tcadmin help &7- Show this help message"));
        return true;
    }

    private boolean handleInvalidUsage(CommandSender sender) {
        sender.sendMessage(this.plugin.colorize("&c[TreeCutter] Invalid usage! Use '/treecutteradmin help' for commands."));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!sender.hasPermission("treecutter.admin")) {
            return completions;
        }
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("reload", "config", "info", "player", "cache", "cleanup", "debug", "help");
            String input = args[0].toLowerCase();
            for (String subCommand : subCommands) {
                if (!subCommand.startsWith(input)) continue;
                completions.add(subCommand);
            }
        } else if (args.length == 2) {
            String subCommand = args[0].toLowerCase();
            if ("player".equals(subCommand)) {
                String input = args[1].toLowerCase();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(input)) continue;
                    completions.add(player.getName());
                }
            } else if ("cache".equals(subCommand)) {
                completions.add("clear");
            } else if ("debug".equals(subCommand)) {
                completions.addAll(Arrays.asList("on", "off", "enable", "disable"));
            }
        } else if (args.length == 3 && "player".equals(args[0].toLowerCase())) {
            completions.addAll(Arrays.asList("enable", "disable", "info"));
        }
        return completions;
    }
}

