/*
 * Decompiled with CFR 0.152.
 */
package com.treecutter.commands;

import com.treecutter.TreeCutterPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TreeCutterCommand
implements CommandExecutor,
TabCompleter {
    private final TreeCutterPlugin plugin;

    public TreeCutterCommand(TreeCutterPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.colorize("&c[TreeCutter] This command can only be used by players!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("treecutter.use")) {
            player.sendMessage(this.plugin.getMessage("no-permission"));
            return true;
        }
        if (!this.plugin.isPluginEnabled()) {
            player.sendMessage(this.plugin.getMessage("plugin-disabled"));
            return true;
        }
        if (!this.plugin.getTreeDetector().isWorldEnabled(player.getWorld().getName())) {
            player.sendMessage(this.plugin.getMessage("world-disabled"));
            return true;
        }
        if (args.length == 0) {
            return this.handleToggle(player);
        }
        if (args.length == 1) {
            String action;
            switch (action = args[0].toLowerCase()) {
                case "on": 
                case "enable": 
                case "true": {
                    return this.handleEnable(player);
                }
                case "off": 
                case "disable": 
                case "false": {
                    return this.handleDisable(player);
                }
                case "status": 
                case "info": {
                    return this.handleStatus(player);
                }
                case "help": {
                    return this.handleHelp(player);
                }
            }
            return this.handleInvalidUsage(player);
        }
        return this.handleInvalidUsage(player);
    }

    private boolean handleToggle(Player player) {
        this.plugin.getPlayerDataManager().toggleTreeCutting(player);
        boolean enabled = this.plugin.getPlayerDataManager().isTreeCuttingEnabled(player);
        String messageKey = enabled ? "enabled" : "disabled";
        player.sendMessage(this.plugin.getMessage(messageKey));
        this.plugin.debugLog(player.getName() + " toggled tree cutting to: " + enabled);
        return true;
    }

    private boolean handleEnable(Player player) {
        if (this.plugin.getPlayerDataManager().isTreeCuttingEnabled(player)) {
            player.sendMessage(this.plugin.getMessage("enabled").replace("enabled", "already enabled"));
        } else {
            this.plugin.getPlayerDataManager().setTreeCuttingEnabled(player, true);
            player.sendMessage(this.plugin.getMessage("enabled"));
        }
        return true;
    }

    private boolean handleDisable(Player player) {
        if (!this.plugin.getPlayerDataManager().isTreeCuttingEnabled(player)) {
            player.sendMessage(this.plugin.getMessage("disabled").replace("disabled", "already disabled"));
        } else {
            this.plugin.getPlayerDataManager().setTreeCuttingEnabled(player, false);
            player.sendMessage(this.plugin.getMessage("disabled"));
        }
        return true;
    }

    private boolean handleStatus(Player player) {
        boolean enabled = this.plugin.getPlayerDataManager().isTreeCuttingEnabled(player);
        boolean worldEnabled = this.plugin.getTreeDetector().isWorldEnabled(player.getWorld().getName());
        boolean pluginEnabled = this.plugin.isPluginEnabled();
        player.sendMessage(this.plugin.getMessage("status-header"));
        player.sendMessage(this.plugin.getMessage("status-personal", "%state%", enabled ? this.plugin.getMessage("state-enabled") : this.plugin.getMessage("state-disabled")));
        player.sendMessage(this.plugin.getMessage("status-world", "%world_state%", worldEnabled ? this.plugin.getMessage("state-enabled") : this.plugin.getMessage("state-disabled")));
        player.sendMessage(this.plugin.getMessage("status-plugin", "%plugin_state%", pluginEnabled ? this.plugin.getMessage("state-enabled") : this.plugin.getMessage("state-disabled")));
        if (enabled && worldEnabled && pluginEnabled) {
            player.sendMessage(this.plugin.getMessage("status-active"));
        } else {
            player.sendMessage(this.plugin.getMessage("status-inactive"));
        }
        return true;
    }

    private boolean handleHelp(Player player) {
        player.sendMessage(this.plugin.getMessage("help-header"));
        player.sendMessage(this.plugin.getMessage("help-toggle"));
        player.sendMessage(this.plugin.getMessage("help-on"));
        player.sendMessage(this.plugin.getMessage("help-off"));
        player.sendMessage(this.plugin.getMessage("help-status"));
        player.sendMessage(this.plugin.getMessage("help-help"));
        player.sendMessage(this.plugin.colorize(""));
        player.sendMessage(this.plugin.getMessage("help-usage-header"));
        player.sendMessage(this.plugin.getMessage("help-step1"));
        player.sendMessage(this.plugin.getMessage("help-step2"));
        player.sendMessage(this.plugin.getMessage("help-step3"));
        player.sendMessage(this.plugin.colorize(""));
        player.sendMessage(this.plugin.getMessage("help-note"));
        return true;
    }

    private boolean handleInvalidUsage(Player player) {
        player.sendMessage(this.plugin.colorize("&c[TreeCutter] Invalid usage!"));
        player.sendMessage(this.plugin.colorize("&e/treecutter [on|off|status|help]"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> options = Arrays.asList("on", "off", "enable", "disable", "status", "info", "help");
            String input = args[0].toLowerCase();
            for (String option : options) {
                if (!option.startsWith(input)) continue;
                completions.add(option);
            }
        }
        return completions;
    }
}

