/*
 * Decompiled with CFR 0.152.
 */
package com.treecutter.listeners;

import com.treecutter.TreeCutterPlugin;
import com.treecutter.utils.TreeDetector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TreeCutterListener
implements Listener {
    private final TreeCutterPlugin plugin;
    private final Set<UUID> processingPlayers;

    public TreeCutterListener(TreeCutterPlugin plugin) {
        this.plugin = plugin;
        this.processingPlayers = new HashSet<UUID>();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.shouldProcessTreeCutting(player, block = event.getBlock())) {
            return;
        }
        if (this.processingPlayers.contains(player.getUniqueId())) {
            return;
        }
        this.plugin.debugLog("Processing tree cutting for " + player.getName() + " at " + this.locationToString(block.getLocation()));
        TreeDetector.TreeStructure tree = this.plugin.getTreeDetector().detectTree(block);
        if (tree == null) {
            this.plugin.debugLog("No tree detected for " + player.getName());
            return;
        }
        if (tree.getLogCount() < this.plugin.getMinLogsForTree()) {
            this.plugin.debugLog("Tree too small for cutting: " + tree.getLogCount() + " logs");
            return;
        }
        this.plugin.debugLog("Detected tree with " + tree.getLogCount() + " logs for " + player.getName());
        if (this.plugin.isDebugMode()) {
            String debugMsg = this.plugin.getConfig().getString("messages.debug-tree-detected", "&7[TreeCutter Debug] Tree detected with %logs% logs").replace("%logs%", String.valueOf(tree.getLogCount()));
            this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("treecutter.admin")).forEach(admin -> admin.sendMessage(this.plugin.colorize(debugMsg)));
        }
        if (this.plugin.isAsyncProcessingEnabled() && tree.getLogCount() > 32) {
            this.processingPlayers.add(player.getUniqueId());
            this.processTreeAsync(player, tree, event.getBlock());
        } else {
            this.processingPlayers.add(player.getUniqueId());
            this.processTreeSync(player, tree, event.getBlock());
        }
    }

    private boolean shouldProcessTreeCutting(Player player, Block block) {
        if (!this.plugin.isPluginEnabled()) {
            return false;
        }
        if (!player.hasPermission("treecutter.use")) {
            return false;
        }
        if (!player.isSneaking()) {
            this.plugin.debugLog(player.getName() + " is not crouching, skipping tree cutting");
            return false;
        }
        if (!this.plugin.getTreeDetector().isAllowedLog(block.getType())) {
            return false;
        }
        if (!this.plugin.getTreeDetector().isWorldEnabled(block.getWorld().getName())) {
            this.plugin.debugLog("Tree cutting disabled in world: " + block.getWorld().getName());
            return false;
        }
        if (!this.plugin.getPlayerDataManager().isTreeCuttingEnabled(player)) {
            this.plugin.debugLog(player.getName() + " has tree cutting disabled");
            return false;
        }
        if (this.plugin.isPlayerOnCooldown(player.getUniqueId())) {
            this.plugin.debugLog(player.getName() + " is on cooldown");
            return false;
        }
        return player.getGameMode() != GameMode.SPECTATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTreeSync(Player player, TreeDetector.TreeStructure tree, Block originalBlock) {
        try {
            Set<Location> logLocations = tree.getLogLocations();
            ItemStack tool = player.getInventory().getItemInMainHand();
            HashMap<Material, Integer> totalDrops = new HashMap<Material, Integer>();
            boolean hasFortuneOrSilkTouch = this.hasFortune(tool) || this.hasSilkTouch(tool);
            for (Location logLoc : logLocations) {
                Block logBlock = logLoc.getBlock();
                if (!this.plugin.getTreeDetector().isAllowedLog(logBlock.getType())) continue;
                Collection drops = logBlock.getDrops(tool);
                for (ItemStack drop : drops) {
                    totalDrops.merge(drop.getType(), drop.getAmount(), Integer::sum);
                }
                if (logBlock.equals((Object)originalBlock) && this.isToolDamageable(tool)) {
                    this.damageTool(player, tool, 1);
                }
                logBlock.setType(Material.AIR);
            }
            Location dropLocation = this.plugin.shouldDropAtPlayer() ? player.getLocation() : originalBlock.getLocation();
            this.dropItems(dropLocation, totalDrops);
            this.plugin.setPlayerCooldown(player.getUniqueId());
            String chatMessage = this.plugin.getMessage("tree-cut-success", "%logs%", String.valueOf(logLocations.size()));
            player.sendMessage(chatMessage);
            String actionBarMessage = this.plugin.getMessage("tree-cut-actionbar", "%logs%", String.valueOf(logLocations.size()));
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(actionBarMessage));
            this.plugin.debugLog("Successfully cut tree for " + player.getName() + " - " + logLocations.size() + " logs");
        }
        finally {
            this.processingPlayers.remove(player.getUniqueId());
        }
    }

    private void processTreeAsync(final Player player, final TreeDetector.TreeStructure tree, final Block originalBlock) {
        new BukkitRunnable(this){
            final /* synthetic */ TreeCutterListener this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                try {
                    final Set<Location> logLocations = tree.getLogLocations();
                    final ItemStack tool = player.getInventory().getItemInMainHand();
                    final HashMap<Material, Integer> totalDrops = new HashMap<Material, Integer>();
                    for (Location logLoc : logLocations) {
                        Block logBlock = logLoc.getBlock();
                        if (!this.this$0.plugin.getTreeDetector().isAllowedLog(logBlock.getType())) continue;
                        Collection drops = logBlock.getDrops(tool);
                        for (ItemStack drop : drops) {
                            totalDrops.merge(drop.getType(), drop.getAmount(), Integer::sum);
                        }
                    }
                    new BukkitRunnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                for (Location logLoc : logLocations) {
                                    Block logBlock = logLoc.getBlock();
                                    if (!this.this$1.this$0.plugin.getTreeDetector().isAllowedLog(logBlock.getType())) continue;
                                    logBlock.setType(Material.AIR);
                                }
                                if (this.this$1.this$0.isToolDamageable(tool)) {
                                    this.this$1.this$0.damageTool(player, tool, 1);
                                }
                                Location dropLocation = this.this$1.this$0.plugin.shouldDropAtPlayer() ? player.getLocation() : originalBlock.getLocation();
                                this.this$1.this$0.dropItems(dropLocation, totalDrops);
                                this.this$1.this$0.plugin.setPlayerCooldown(player.getUniqueId());
                                String chatMessage = this.this$1.this$0.plugin.getMessage("tree-cut-success", "%logs%", String.valueOf(logLocations.size()));
                                player.sendMessage(chatMessage);
                                String actionBarMessage = this.this$1.this$0.plugin.getMessage("tree-cut-actionbar", "%logs%", String.valueOf(logLocations.size()));
                                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(actionBarMessage));
                                this.this$1.this$0.plugin.debugLog("Successfully cut tree (async) for " + player.getName() + " - " + logLocations.size() + " logs");
                            }
                            finally {
                                this.this$1.this$0.processingPlayers.remove(player.getUniqueId());
                            }
                        }
                    }.runTask((Plugin)this.this$0.plugin);
                }
                catch (Exception e) {
                    this.this$0.plugin.getLogger().warning("Error in async tree processing: " + e.getMessage());
                    this.this$0.processingPlayers.remove(player.getUniqueId());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void dropItems(Location location, Map<Material, Integer> items) {
        for (Map.Entry<Material, Integer> entry : items.entrySet()) {
            int stackSize;
            Material material = entry.getKey();
            for (int amount = entry.getValue().intValue(); amount > 0; amount -= stackSize) {
                stackSize = Math.min(amount, material.getMaxStackSize());
                ItemStack stack = new ItemStack(material, stackSize);
                location.getWorld().dropItemNaturally(location, stack);
            }
        }
    }

    private boolean hasFortune(ItemStack tool) {
        return tool != null && tool.containsEnchantment(Enchantment.FORTUNE);
    }

    private boolean hasSilkTouch(ItemStack tool) {
        return tool != null && tool.containsEnchantment(Enchantment.SILK_TOUCH);
    }

    private boolean isToolDamageable(ItemStack tool) {
        if (tool == null || tool.getType() == Material.AIR) {
            return false;
        }
        return tool.getType().getMaxDurability() > 0;
    }

    private void damageTool(Player player, ItemStack tool, int damage) {
        Random random;
        if (!this.isToolDamageable(tool)) {
            return;
        }
        int unbreakingLevel = tool.getEnchantmentLevel(Enchantment.UNBREAKING);
        if (unbreakingLevel > 0 && (random = new Random()).nextInt(unbreakingLevel + 1) > 0) {
            return;
        }
        if (tool.getDurability() + damage >= tool.getType().getMaxDurability()) {
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            player.sendMessage(this.plugin.colorize("&6Your tool broke while tree cutting!"));
        } else {
            tool.setDurability((short)(tool.getDurability() + damage));
        }
    }

    private String locationToString(Location loc) {
        return String.format("%s:(%d,%d,%d)", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }
}

