/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleOperationHelper;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ClassLoaderAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.JarModuleReferenceAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleLayerHandlerAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleReferenceAccessor;

public class ModuleReplacer {
    public static void replace(String moduleName, SecureJar newJar, ModuleLayer layer, ModuleClassLoader classLoader) {
        Module module = layer.findModule(moduleName).orElseThrow(() -> new RuntimeException("Module not found: " + moduleName));
        ResolvedModule resolvedModule = layer.configuration().findModule(moduleName).orElseThrow(() -> new RuntimeException("Resolved module not found: " + moduleName));
        ModuleReference reference = resolvedModule.reference();
        if (!JarModuleReferenceAccessor.isJarModuleReference(reference)) {
            throw new RuntimeException("Module does not use a jar module reference: " + moduleName);
        }
        SecureJar.ModuleDataProvider replacementProvider = newJar.moduleDataProvider();
        ModuleDescriptor replacementDescriptor = replacementProvider.descriptor();
        Set<String> newPackages = replacementDescriptor.packages();
        JarModuleReferenceAccessor.setJar(reference, replacementProvider);
        ModuleReferenceAccessor.setDescriptor(reference, replacementDescriptor);
        ModuleReferenceAccessor.setLocation(reference, newJar.getRootPath().toUri());
        ModuleAccessor.implAddReads(module, module.getClassLoader().getUnnamedModule());
        ModuleReplacer.clearPackageCertificates(module.getClassLoader(), newPackages);
        ModuleOperationHelper.updatePackageLookupForModule(classLoader, resolvedModule, newPackages);
    }

    public static void replace(String moduleName, Path newJarPath, ModuleLayer layer, ModuleClassLoader classLoader) {
        ModuleReplacer.replace(moduleName, SecureJar.from((Path[])new Path[]{newJarPath}), layer, classLoader);
    }

    public static void replace(String moduleName, SecureJar newJar, IModuleLayerManager.Layer targetLayer) {
        ModuleReplacer.replace(moduleName, newJar, LauncherAccessor.getModuleLayer(targetLayer), ModuleLayerHandlerAccessor.getModuleClassLoader(targetLayer));
    }

    public static void replace(String moduleName, Path newJarPath, IModuleLayerManager.Layer targetLayer) {
        ModuleReplacer.replace(moduleName, SecureJar.from((Path[])new Path[]{newJarPath}), targetLayer);
    }

    public static void replace(Class<?> classInModule, SecureJar newJar) {
        ModuleReplacer.replace(classInModule.getModule().getName(), newJar, classInModule.getModule().getLayer(), (ModuleClassLoader)classInModule.getClassLoader());
    }

    public static void replace(Class<?> classInModule, Path newJarPath) {
        ModuleReplacer.replace(classInModule, SecureJar.from((Path[])new Path[]{newJarPath}));
    }

    public static void replaceMultiple(String[] moduleNames, SecureJar[] newJars, ModuleLayer layer, ModuleClassLoader classLoader) {
        if (moduleNames.length != newJars.length) {
            throw new IllegalArgumentException("Module names and JARs must have the same length: " + moduleNames.length + " vs " + newJars.length);
        }
        for (int i = 0; i < moduleNames.length; ++i) {
            ModuleReplacer.replace(moduleNames[i], newJars[i], layer, classLoader);
        }
    }

    public static void replaceMultiple(String[] moduleNames, Path[] newJarPaths, ModuleLayer layer, ModuleClassLoader classLoader) {
        if (moduleNames.length != newJarPaths.length) {
            throw new IllegalArgumentException("Module names and JAR paths must have the same length: " + moduleNames.length + " vs " + newJarPaths.length);
        }
        SecureJar[] newJars = new SecureJar[newJarPaths.length];
        for (int i = 0; i < newJarPaths.length; ++i) {
            newJars[i] = SecureJar.from((Path[])new Path[]{newJarPaths[i]});
        }
        ModuleReplacer.replaceMultiple(moduleNames, newJars, layer, classLoader);
    }

    private static void clearPackageCertificates(ClassLoader classLoader, Set<String> packages) {
        Map<String, ?> certs = ClassLoaderAccessor.getPackage2Certs(classLoader);
        for (String pkg : packages) {
            certs.remove(pkg);
        }
    }
}

