/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.forgelike.class_transform;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.lenni0451.classtransform.TransformerManager;
import net.lenni0451.classtransform.additionalclassprovider.InstrumentationClassProvider;
import net.lenni0451.classtransform.utils.ASMUtils;
import net.lenni0451.classtransform.utils.tree.IClassProvider;
import net.lenni0451.reflect.Agents;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformConfig;

public final class ClassTransformBootstrap {
    public static final String CLASS_TRANSFORM_CONFIG = "ClassTransformConfig";
    public static ClassTransformBootstrap INSTANCE;
    private final TransformerManager transformerManager;
    private final Gson gson = new Gson();

    public ClassTransformBootstrap() throws IOException {
        if (INSTANCE != null) {
            throw new IllegalStateException("ClassTransformBootstrap is already initialized");
        }
        INSTANCE = this;
        this.transformerManager = new TransformerManager((IClassProvider)new InstrumentationClassProvider(Agents.getInstrumentation()));
    }

    public TransformerManager getTransformerManager() {
        return this.transformerManager;
    }

    public void addConfig(ClassTransformConfig config) throws ClassNotFoundException {
        for (String transformer : config.transformers()) {
            String transformerClassName = config.packageName() + "." + transformer;
            this.transformerManager.addTransformer(ASMUtils.fromBytes((byte[])this.transformerManager.getClassProvider().getClass(transformerClassName)));
        }
    }

    public void addConfig(String configName, ClassLoader classLoader) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(configName)));
            ClassTransformConfig config = (ClassTransformConfig)this.gson.fromJson((Reader)reader, ClassTransformConfig.class);
            this.addConfig(config);
            reader.close();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to read config " + configName, e);
        }
    }

    public void addConfig(String configName) {
        this.addConfig(configName, Thread.currentThread().getContextClassLoader());
    }
}

