/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.lexforge;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import settingdust.preloading_tricks.api.PreloadingTricksModManager;
import settingdust.preloading_tricks.lexforge.accessor.FMLLoaderAccessor;
import settingdust.preloading_tricks.lexforge.accessor.ModFileInfoAccessor;
import settingdust.preloading_tricks.lexforge.accessor.ModValidatorAccessor;

public class LexForgeModManager
implements PreloadingTricksModManager<ModFile> {
    private final List<ModFile> mods = ModValidatorAccessor.getCandidateMods(FMLLoaderAccessor.getModValidator());

    @Override
    public Collection<ModFile> all() {
        return this.mods;
    }

    @Override
    public void add(ModFile mod) {
        this.mods.add(mod);
    }

    @Override
    public void addAll(Collection<ModFile> mod) {
        this.mods.addAll(mod);
    }

    @Override
    public void remove(ModFile mod) {
        this.mods.remove(mod);
    }

    @Override
    public void removeIf(Predicate<ModFile> predicate) {
        this.mods.removeIf(predicate);
    }

    @Override
    public void removeAll(Collection<ModFile> modFiles) {
        this.mods.removeAll(modFiles);
    }

    @Override
    public void removeById(String id) {
        this.removeByIds(Set.of(id));
    }

    @Override
    public void removeByIds(Set<String> ids) {
        Iterator<ModFile> iterator = this.mods.iterator();
        while (iterator.hasNext()) {
            ModFile mod = iterator.next();
            IModFileInfo iModFileInfo = mod.getModFileInfo();
            if (!(iModFileInfo instanceof ModFileInfo)) continue;
            ModFileInfo modFileInfo = (ModFileInfo)iModFileInfo;
            List<IModInfo> filtered = mod.getModInfos().stream().filter(it -> !ids.contains(it.getModId())).toList();
            if (filtered.isEmpty()) {
                iterator.remove();
                continue;
            }
            ModFileInfoAccessor.setMods(modFileInfo, filtered);
        }
    }
}

