/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.Configuration;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.HashMap;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleLayerAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleOperationHelper;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleClassLoaderAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleLayerHandlerAccessor;

public class ModuleCopier {
    public static void copy(String moduleName, ModuleLayer sourceLayer, ModuleLayer targetLayer, ModuleClassLoader targetClassLoader) {
        ResolvedModule resolvedModule = sourceLayer.configuration().findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
        Module module = sourceLayer.findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
        ModuleAccessor.setLayer(module, targetLayer);
        HashMap<String, ResolvedModule> toPackageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(targetClassLoader));
        HashMap<String, ModuleReference> toResolvedRoots = new HashMap<String, ModuleReference>(ModuleClassLoaderAccessor.getResolvedRoots(targetClassLoader));
        Configuration toConfiguration = targetLayer.configuration();
        for (String packageName : resolvedModule.reference().descriptor().packages()) {
            toPackageLookup.put(packageName, resolvedModule);
        }
        toResolvedRoots.put(resolvedModule.name(), resolvedModule.reference());
        ModuleLayerAccessor.getNameToModule(targetLayer).put(resolvedModule.name(), module);
        ModuleOperationHelper.addModuleToConfiguration(toConfiguration, resolvedModule);
        ModuleClassLoaderAccessor.setPackageLookup(targetClassLoader, toPackageLookup);
        ModuleClassLoaderAccessor.setResolvedRoots(targetClassLoader, toResolvedRoots);
    }

    public static void copy(String moduleName, IModuleLayerManager.Layer sourceLayer, IModuleLayerManager.Layer targetLayer) {
        ModuleCopier.copy(moduleName, LauncherAccessor.getModuleLayer(sourceLayer), LauncherAccessor.getModuleLayer(targetLayer), ModuleLayerHandlerAccessor.getModuleClassLoader(targetLayer));
    }

    public static void copy(Class<?> classInModule, ModuleLayer targetLayer, ModuleClassLoader targetClassLoader) {
        ModuleCopier.copy(classInModule.getModule().getName(), classInModule.getModule().getLayer(), targetLayer, targetClassLoader);
    }

    public static void copy(Class<?> classInModule, IModuleLayerManager.Layer targetLayer) {
        ModuleCopier.copy(classInModule, LauncherAccessor.getModuleLayer(targetLayer), ModuleLayerHandlerAccessor.getModuleClassLoader(targetLayer));
    }
}

