/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.neoforge.modlauncher;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import settingdust.preloading_tricks.api.PreloadingTricksModManager;
import settingdust.preloading_tricks.neoforge.modlauncher.accessor.ModFileInfoAccessor;
import settingdust.preloading_tricks.neoforge.modlauncher.virtual_mod.VirtualJar;
import settingdust.preloading_tricks.neoforge.modlauncher.virtual_mod.VirtualModFile;

public class NeoForgeModManager
implements PreloadingTricksModManager<ModFile> {
    public static List<ModFile> mods = null;

    @Override
    public Collection<ModFile> all() {
        return mods;
    }

    @Override
    public void add(ModFile mod) {
        mods.add(mod);
    }

    @Override
    public void addAll(Collection<ModFile> mod) {
        mods.addAll(mod);
    }

    @Override
    public void remove(ModFile mod) {
        mods.remove(mod);
    }

    @Override
    public void removeIf(Predicate<ModFile> predicate) {
        mods.removeIf(predicate);
    }

    @Override
    public void removeAll(Collection<ModFile> all) {
        mods.removeAll(all);
    }

    @Override
    public void removeById(String id) {
        this.removeByIds(Set.of(id));
    }

    @Override
    public void removeByIds(Set<String> ids) {
        Iterator<ModFile> iterator = mods.iterator();
        while (iterator.hasNext()) {
            IModFileInfo iModFileInfo;
            ModFile mod = iterator.next();
            if (mod.getModInfos().isEmpty() || !((iModFileInfo = mod.getModFileInfo()) instanceof ModFileInfo)) continue;
            ModFileInfo modFileInfo = (ModFileInfo)iModFileInfo;
            List<IModInfo> filtered = mod.getModInfos().stream().filter(it -> !ids.contains(it.getModId())).toList();
            if (filtered.isEmpty()) {
                iterator.remove();
                continue;
            }
            ModFileInfoAccessor.setMods(modFileInfo, filtered);
        }
    }

    @Override
    public ModFile createVirtualMod(String id, Path referencePath) {
        return new VirtualModFile(id, new VirtualJar(id, referencePath, new String[0]));
    }
}

