/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.ModuleClassLoader;
import java.lang.module.Configuration;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ConfigurationAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleLayerAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ResolvedModuleAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleClassLoaderAccessor;

public class ModuleOperationHelper {
    public static Module createAndRegisterModule(ResolvedModule resolvedModule, ModuleLayer targetLayer, ModuleClassLoader targetClassLoader, Configuration targetConfig) {
        Module module = ModuleAccessor.construct(targetLayer, (ClassLoader)targetClassLoader, resolvedModule.reference().descriptor(), resolvedModule.reference().location().orElse(null));
        ModuleLayerAccessor.getNameToModule(targetLayer).put(resolvedModule.name(), module);
        ResolvedModuleAccessor.setCf(resolvedModule, targetConfig);
        return module;
    }

    public static void setupMutualReads(Iterable<Module> modulesToLink, Module baseModule) {
        ArrayList moduleList = new ArrayList();
        modulesToLink.forEach(moduleList::add);
        for (Module module : moduleList) {
            ModuleAccessor.implAddReads(baseModule, module);
            for (Module other : moduleList) {
                if (module == other) continue;
                ModuleAccessor.implAddReads(module, other);
            }
        }
    }

    public static void updatePackageLookup(ModuleClassLoader classLoader, Iterable<ResolvedModule> newModules) {
        HashMap<String, ResolvedModule> packageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(classLoader));
        for (ResolvedModule module : newModules) {
            for (String packageName : module.reference().descriptor().packages()) {
                packageLookup.put(packageName, module);
            }
        }
        ModuleClassLoaderAccessor.setPackageLookup(classLoader, packageLookup);
    }

    public static void updateResolvedRoots(ModuleClassLoader classLoader, Iterable<ResolvedModule> newModules) {
        HashMap<String, ModuleReference> resolvedRoots = new HashMap<String, ModuleReference>(ModuleClassLoaderAccessor.getResolvedRoots(classLoader));
        for (ResolvedModule module : newModules) {
            resolvedRoots.put(module.name(), module.reference());
        }
        ModuleClassLoaderAccessor.setResolvedRoots(classLoader, resolvedRoots);
    }

    public static void updatePackageLookupForModule(ModuleClassLoader classLoader, ResolvedModule resolvedModule, Iterable<String> packages) {
        HashMap<String, ResolvedModule> packageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(classLoader));
        for (String pkg : packages) {
            packageLookup.put(pkg, resolvedModule);
        }
        ModuleClassLoaderAccessor.setPackageLookup(classLoader, packageLookup);
    }

    public static void mergeConfigurations(Configuration targetConfig, Configuration sourceConfig) {
        ConfigurationAccessor.getGraph(targetConfig).putAll(ConfigurationAccessor.getGraph(sourceConfig));
        HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(ConfigurationAccessor.getModules(targetConfig));
        modules.addAll(ConfigurationAccessor.getModules(sourceConfig));
        ConfigurationAccessor.setModules(targetConfig, modules);
        HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>(ConfigurationAccessor.getNameToModule(targetConfig));
        nameToModule.putAll(ConfigurationAccessor.getNameToModule(sourceConfig));
        ConfigurationAccessor.setNameToModule(targetConfig, nameToModule);
    }

    public static void addModuleToConfiguration(Configuration targetConfig, ResolvedModule moduleToAdd) {
        ConfigurationAccessor.getGraph(targetConfig).put(moduleToAdd, moduleToAdd.reads());
        HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(ConfigurationAccessor.getModules(targetConfig));
        modules.add(moduleToAdd);
        ConfigurationAccessor.setModules(targetConfig, modules);
        HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>(ConfigurationAccessor.getNameToModule(targetConfig));
        nameToModule.put(moduleToAdd.name(), moduleToAdd);
        ConfigurationAccessor.setNameToModule(targetConfig, nameToModule);
        ResolvedModuleAccessor.setCf(moduleToAdd, targetConfig);
    }

    public static void removeModuleFromConfiguration(Configuration config, ResolvedModule moduleToRemove) {
        ConfigurationAccessor.getGraph(config).remove(moduleToRemove);
        HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(ConfigurationAccessor.getModules(config));
        modules.remove(moduleToRemove);
        ConfigurationAccessor.setModules(config, modules);
        HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>(ConfigurationAccessor.getNameToModule(config));
        nameToModule.remove(moduleToRemove.name());
        ConfigurationAccessor.setNameToModule(config, nameToModule);
    }
}

