/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.forgelike;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.function.Supplier;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.forgelike.JavaBypass;
import settingdust.preloading_tricks.forgelike.UnsafeHacks;

public class UcpClassLoaderInjector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inject(Path primaryPath, String prefix, String relativePath, Supplier<InputStream> fileSupplier, ClassLoader classLoader) {
        Path tempFile;
        Path cachePath = Path.of(".cache", "preloading_tricks");
        try {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            tempFile = Files.createTempFile(cachePath, "_nested", ".tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create a temporary file for nested jar in " + String.valueOf(cachePath) + ": " + String.valueOf(e));
        }
        try {
            String hash = UcpClassLoaderInjector.extractEmbeddedJarFile(primaryPath, fileSupplier.get(), relativePath, tempFile);
            String filename = relativePath.substring(prefix.length() + 1);
            Path finalPath = cachePath.resolve(hash + "/" + filename);
            if (!Files.isRegularFile(finalPath, new LinkOption[0])) {
                UcpClassLoaderInjector.moveExtractedFileIntoPlace(tempFile, finalPath);
            }
            try {
                UcpClassLoaderInjector.appendToClassLoader(finalPath.toUri().toURL(), classLoader);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException e) {
                PreloadingTricks.LOGGER.error("Failed to remove temporary file {}: {}", (Object)tempFile, (Object)e);
            }
        }
    }

    public static void appendToClassLoader(URL url, ClassLoader classLoader) throws Throwable {
        Field ucpField;
        try {
            ucpField = classLoader.getClass().getDeclaredField("ucp");
        }
        catch (NoSuchFieldException e) {
            ucpField = classLoader.getClass().getSuperclass().getDeclaredField("ucp");
        }
        Object ucp = UnsafeHacks.getField(ucpField, classLoader);
        Class<?> ucpClass = ucp.getClass();
        MethodHandle addURLHandle = JavaBypass.getTrustedLookup().in(ucpClass).findVirtual(ucpClass, "addURL", MethodType.methodType(Void.TYPE, URL.class));
        addURLHandle.invoke(ucp, url);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String extractEmbeddedJarFile(Path primaryPath, InputStream fileStream, String relativePath, Path destination) {
        try (InputStream inStream = fileStream;){
            String string;
            block16: {
                OutputStream outStream = Files.newOutputStream(destination, new OpenOption[0]);
                try {
                    MessageDigest digest;
                    try {
                        digest = MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("Missing default JCA algorithm SHA-256.", e);
                    }
                    DigestOutputStream digestOut = new DigestOutputStream(outStream, digest);
                    inStream.transferTo(digestOut);
                    string = HexFormat.of().formatHex(digest.digest());
                    if (outStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outStream.close();
            }
            return string;
        }
        catch (IOException e) {
            PreloadingTricks.LOGGER.error("Failed to copy nested jar file {} from file {} to {}", (Object)relativePath, (Object)primaryPath, (Object)destination, (Object)e);
            throw new IllegalStateException("Failed to load mod file " + String.valueOf(primaryPath.getFileName()), e);
        }
    }

    private static void moveExtractedFileIntoPlace(Path source, Path destination) {
        try {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create parent directory for extracted nested jar file " + String.valueOf(source) + " at " + String.valueOf(destination), e);
        }
        try {
            try {
                Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException ex) {
                Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to move temporary nested file " + String.valueOf(source) + " to its final location " + String.valueOf(destination), e);
        }
    }
}

