/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.lexforge;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.niofs.union.UnionPath;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Set;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.api.PreloadingTricksCallback;
import settingdust.preloading_tricks.api.PreloadingTricksModManager;
import settingdust.preloading_tricks.forgelike.specified_forge_variant.ForgeVariants;
import settingdust.preloading_tricks.util.LoaderPredicates;

public class LexForgePreloadingTricksCallback
implements PreloadingTricksCallback {
    @Override
    public void onSetupMods() {
        LoaderPredicates.Forge.throwIfNot();
        Object manager = PreloadingTricksModManager.get();
        try {
            ModFile mod2 = (ModFile)manager.createVirtualMod("preloading_tricks", ((UnionPath)Path.of(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI())).getFileSystem().getPrimaryPath());
            manager.add((ModFile)mod2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        manager.removeIf(it -> {
            boolean shouldRemove;
            Manifest manifest = it.getSecureJar().moduleDataProvider().getManifest();
            String variantString = manifest.getMainAttributes().getValue("ForgeVariant");
            if (variantString == null) {
                return false;
            }
            ForgeVariants variant = ForgeVariants.BY_NAME.get(variantString.toLowerCase());
            boolean bl = shouldRemove = variant != null && variant != ForgeVariants.LexForge;
            if (shouldRemove) {
                PreloadingTricks.LOGGER.debug("Avoid {} from loading for variant {}", (Object)it.getFilePath(), (Object)variant);
            }
            return shouldRemove;
        });
        Set<String> packagesToRemove = Set.of("net.lenni0451.reflect");
        manager.removeIf(mod -> {
            SecureJar jar = mod.getSecureJar();
            boolean needRemove = packagesToRemove.stream().anyMatch(it -> jar.getPackages().contains(it));
            if (needRemove) {
                PreloadingTricks.LOGGER.debug("Avoid {} from loading for packages {}", (Object)mod.getFilePath(), (Object)packagesToRemove);
            }
            return needRemove;
        });
    }
}

