/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.function.BooleanSupplier;

public enum LoaderPredicates {
    Fabric(() -> {
        boolean result = false;
        try {
            Class.forName("net.fabricmc.loader.api.FabricLoader");
            result = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }),
    Forge(() -> {
        boolean result = false;
        try {
            Class.forName("net.minecraftforge.fml.loading.FMLLoader");
            result = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }),
    NeoForgeModLauncher(() -> {
        boolean result = false;
        try {
            Class.forName("net.neoforged.fml.loading.FMLLoader");
            Class.forName("cpw.mods.jarhandling.SecureJar");
            result = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }),
    NeoForge(() -> {
        boolean result = false;
        try {
            Class.forName("net.neoforged.fml.classloading.ModuleClassLoader");
            result = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    });

    private final BooleanSupplier predicate = () -> ((Supplier)Suppliers.memoize(predicate::getAsBoolean)).get();

    private LoaderPredicates(BooleanSupplier predicate) {
    }

    public boolean test() {
        return this.predicate.getAsBoolean();
    }

    public boolean strictTest() {
        if (!this.test()) {
            return false;
        }
        for (LoaderPredicates loader : LoaderPredicates.values()) {
            if (loader == this || !loader.test()) continue;
            return false;
        }
        return true;
    }

    public void throwIfNot() {
        if (!this.strictTest()) {
            throw new IllegalStateException(this.name() + " is not for current loader");
        }
    }
}

