/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.neoforge.fancy_mod_loader.class_transform;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.neoforged.fml.classloading.JarContentsModule;
import net.neoforged.fml.jarcontents.JarContents;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformBootstrap;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformConfig;

public class ClassTransformFancyModLoader {
    private static final Gson gson = new Gson();

    public static void addConfig(String configName, JarContents jar) throws IOException, ClassNotFoundException {
        ClassTransformConfig config = (ClassTransformConfig)gson.fromJson((Reader)jar.get(configName).bufferedReader(), ClassTransformConfig.class);
        ClassTransformBootstrap.INSTANCE.addConfig(config);
    }

    public static void addConfig(JarContents jar) {
        String[] classTransformConfigs;
        Object classTransformConfigString = jar.getManifest().getMainAttributes().get("ClassTransformConfig");
        if (classTransformConfigString == null) {
            return;
        }
        for (String classTransformConfig : classTransformConfigs = classTransformConfigString.toString().split(",")) {
            try {
                ClassTransformFancyModLoader.addConfig(classTransformConfig, jar);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void addConfigForLayer(String layerName, List<JarContents> jars) {
        PreloadingTricks.LOGGER.info("Adding transformer config for layer: {}", (Object)layerName);
        for (JarContents jar : jars) {
            ClassTransformFancyModLoader.addConfig(jar);
        }
    }

    public static void addConfigForGameLayer(List<JarContentsModule> jars) {
        PreloadingTricks.LOGGER.info("Adding transformer config for layer: Game");
        for (JarContentsModule jar : jars) {
            ClassTransformFancyModLoader.addConfig(jar.contents());
        }
    }
}

