/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.api;

import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Set;
import settingdust.preloading_tricks.util.ServiceLoaderUtil;

public interface PreloadingTricksCallback {
    public static final Set<ClassLoader> CLASS_LOADERS = Sets.newHashSet((Object[])new ClassLoader[]{PreloadingTricksCallback.class.getClassLoader()});
    public static final PreloadingTricksCallback invoker = new PreloadingTricksCallback(){

        @Override
        public void onSetupLanguageAdapter() {
            CLASS_LOADERS.add(Thread.currentThread().getContextClassLoader());
            for (PreloadingTricksCallback callback : PreloadingTricksCallback.findAllCallbacks()) {
                callback.onSetupLanguageAdapter();
            }
        }

        @Override
        public void onCollectModCandidates() {
            CLASS_LOADERS.add(Thread.currentThread().getContextClassLoader());
            for (PreloadingTricksCallback callback : PreloadingTricksCallback.findAllCallbacks()) {
                callback.onCollectModCandidates();
            }
        }

        @Override
        public void onSetupMods() {
            CLASS_LOADERS.add(Thread.currentThread().getContextClassLoader());
            for (PreloadingTricksCallback callback : PreloadingTricksCallback.findAllCallbacks()) {
                callback.onSetupMods();
            }
        }
    };

    private static Iterable<PreloadingTricksCallback> findAllCallbacks() {
        return CLASS_LOADERS.stream().flatMap(it -> Streams.stream(ServiceLoaderUtil.findServices(PreloadingTricksCallback.class, ServiceLoaderUtil.load(PreloadingTricksCallback.class, it), false))).toList();
    }

    default public void onSetupLanguageAdapter() {
    }

    default public void onCollectModCandidates() {
    }

    default public void onSetupMods() {
    }
}

