/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ConfigurationAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleLayerAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ResolvedModuleAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleClassLoaderAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleLayerHandlerAccessor;

public class ModuleClassLoaderInjector {
    public static void inject(SecureJar jar, ModuleClassLoader classLoader, ModuleLayer moduleLayer) {
        String moduleName = jar.moduleDataProvider().name();
        Configuration moduleConfiguration = ModuleClassLoaderAccessor.getConfiguration(classLoader);
        Configuration jarConfiguration = moduleConfiguration.resolve((ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[]{jar}), (ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[0]), Set.of(moduleName));
        ModuleClassLoaderInjector.mergeConfigurations(moduleConfiguration, jarConfiguration);
        ResolvedModule resolvedModule = jarConfiguration.findModule(moduleName).orElseThrow();
        Module module = ModuleAccessor.construct(moduleLayer, (ClassLoader)classLoader, resolvedModule.reference().descriptor(), resolvedModule.reference().location().orElse(null));
        ModuleLayerAccessor.getNameToModule(moduleLayer).put(resolvedModule.name(), module);
        ModuleClassLoaderInjector.class.getModule().addReads(module);
        for (ResolvedModule resolvedModule2 : ConfigurationAccessor.getGraph(moduleConfiguration).get(resolvedModule)) {
            ModuleAccessor.implAddReads(module, moduleLayer.findModule(resolvedModule2.name()).orElseThrow());
        }
        ResolvedModuleAccessor.setCf(resolvedModule, moduleConfiguration);
        HashMap<String, ResolvedModule> packageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(classLoader));
        for (String name : resolvedModule.reference().descriptor().packages()) {
            packageLookup.put(name, resolvedModule);
        }
        ModuleClassLoaderAccessor.setPackageLookup(classLoader, packageLookup);
        HashMap<String, ModuleReference> hashMap = new HashMap<String, ModuleReference>(ModuleClassLoaderAccessor.getResolvedRoots(classLoader));
        hashMap.put(resolvedModule.name(), resolvedModule.reference());
        ModuleClassLoaderAccessor.setResolvedRoots(classLoader, hashMap);
    }

    public static void inject(Path path, ModuleClassLoader classLoader, ModuleLayer moduleLayer) {
        if (!path.getFileName().toString().endsWith(".jar")) {
            throw new IllegalArgumentException("Path must be a jar: " + String.valueOf(path));
        }
        SecureJar jar = SecureJar.from((Path[])new Path[]{path});
        ModuleClassLoaderInjector.inject(jar, classLoader, moduleLayer);
    }

    public static void inject(Path path, IModuleLayerManager.Layer layer) {
        ModuleClassLoaderInjector.inject(path, ModuleLayerHandlerAccessor.getModuleClassLoader(layer), LauncherAccessor.getModuleLayer(layer));
    }

    public static void inject(Path path, Class<?> clazzInTarget) {
        ModuleClassLoaderInjector.inject(path, (ModuleClassLoader)clazzInTarget.getClassLoader(), clazzInTarget.getModule().getLayer());
    }

    private static void mergeConfigurations(Configuration to, Configuration from) {
        ConfigurationAccessor.getGraph(to).putAll(ConfigurationAccessor.getGraph(from));
        HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(ConfigurationAccessor.getModules(to));
        modules.addAll(ConfigurationAccessor.getModules(from));
        ConfigurationAccessor.setModules(to, modules);
        HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>(ConfigurationAccessor.getNameToModule(to));
        nameToModule.putAll(ConfigurationAccessor.getNameToModule(from));
        ConfigurationAccessor.setNameToModule(to, nameToModule);
    }

    public static void move(String moduleName, ModuleLayer fromModuleLayer, ModuleClassLoader fromModuleClassLoader, ModuleLayer toModuleLayer, ModuleClassLoader toModuleClassLoader) {
        ResolvedModule resolvedModule = fromModuleLayer.configuration().findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
        Module module = fromModuleLayer.findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
        ModuleAccessor.setLayer(module, toModuleLayer);
        HashMap<String, ResolvedModule> fromPackageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(fromModuleClassLoader));
        HashMap<String, ModuleReference> fromResolvedRoots = new HashMap<String, ModuleReference>(ModuleClassLoaderAccessor.getResolvedRoots(fromModuleClassLoader));
        Configuration fromConfiguration = ModuleClassLoaderAccessor.getConfiguration(fromModuleClassLoader);
        HashMap<String, ResolvedModule> toPackageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(toModuleClassLoader));
        HashMap<String, ModuleReference> toResolvedRoots = new HashMap<String, ModuleReference>(ModuleClassLoaderAccessor.getResolvedRoots(toModuleClassLoader));
        Configuration toConfiguration = ModuleClassLoaderAccessor.getConfiguration(toModuleClassLoader);
        for (String packageName : resolvedModule.reference().descriptor().packages()) {
            fromPackageLookup.remove(packageName);
            toPackageLookup.put(packageName, resolvedModule);
        }
        fromResolvedRoots.remove(resolvedModule.name());
        toResolvedRoots.put(resolvedModule.name(), resolvedModule.reference());
        ModuleClassLoaderInjector.moveConfiguration(toConfiguration, fromConfiguration, resolvedModule);
        ModuleClassLoaderAccessor.setPackageLookup(fromModuleClassLoader, fromPackageLookup);
        ModuleClassLoaderAccessor.setResolvedRoots(fromModuleClassLoader, fromResolvedRoots);
        ModuleClassLoaderAccessor.setPackageLookup(toModuleClassLoader, toPackageLookup);
        ModuleClassLoaderAccessor.setResolvedRoots(toModuleClassLoader, toResolvedRoots);
    }

    public static void move(String moduleName, IModuleLayerManager.Layer from, IModuleLayerManager.Layer to) {
        ModuleClassLoaderInjector.move(moduleName, LauncherAccessor.getModuleLayer(from), ModuleLayerHandlerAccessor.getModuleClassLoader(from), LauncherAccessor.getModuleLayer(to), ModuleLayerHandlerAccessor.getModuleClassLoader(to));
    }

    public static void move(Class<?> classInModule, ModuleLayer toModuleLayer, ModuleClassLoader toModuleClassLoader) {
        ModuleClassLoaderInjector.move(classInModule.getModule().getName(), classInModule.getModule().getLayer(), (ModuleClassLoader)classInModule.getClassLoader(), toModuleLayer, toModuleClassLoader);
    }

    public static void move(Class<?> classInModule, IModuleLayerManager.Layer to) {
        ModuleClassLoaderInjector.move(classInModule, LauncherAccessor.getModuleLayer(to), ModuleLayerHandlerAccessor.getModuleClassLoader(to));
    }

    private static void moveConfiguration(Configuration to, Configuration from, ResolvedModule module) {
        ConfigurationAccessor.getGraph(to).put(module, ConfigurationAccessor.getGraph(from).get(module));
        HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(ConfigurationAccessor.getModules(to));
        modules.add(module);
        ConfigurationAccessor.setModules(to, modules);
        HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>(ConfigurationAccessor.getNameToModule(to));
        nameToModule.put(module.name(), module);
        ConfigurationAccessor.setNameToModule(to, nameToModule);
        ConfigurationAccessor.getGraph(from).remove(module);
        HashSet<ResolvedModule> fromModules = new HashSet<ResolvedModule>(ConfigurationAccessor.getModules(to));
        fromModules.remove(module);
        ConfigurationAccessor.setModules(from, fromModules);
        HashMap<String, ResolvedModule> fromNameToModule = new HashMap<String, ResolvedModule>(ConfigurationAccessor.getNameToModule(to));
        fromNameToModule.remove(module.name());
        ConfigurationAccessor.setNameToModule(from, fromNameToModule);
    }
}

