/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.Configuration;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.HashMap;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleOperationHelper;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleClassLoaderAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleLayerHandlerAccessor;

public class ModuleRemover {
    public static void remove(String moduleName, ModuleLayer layer, ModuleClassLoader classLoader) {
        ResolvedModule resolvedModule = layer.configuration().findModule(moduleName).orElseThrow(() -> new RuntimeException("Module %s not found".formatted(moduleName)));
        HashMap<String, ResolvedModule> packageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderAccessor.getPackageLookup(classLoader));
        HashMap<String, ModuleReference> resolvedRoots = new HashMap<String, ModuleReference>(ModuleClassLoaderAccessor.getResolvedRoots(classLoader));
        Configuration configuration = ModuleClassLoaderAccessor.getConfiguration(classLoader);
        for (String packageName : resolvedModule.reference().descriptor().packages()) {
            packageLookup.remove(packageName);
        }
        resolvedRoots.remove(resolvedModule.name());
        ModuleOperationHelper.removeModuleFromConfiguration(configuration, resolvedModule);
        ModuleClassLoaderAccessor.setPackageLookup(classLoader, packageLookup);
        ModuleClassLoaderAccessor.setResolvedRoots(classLoader, resolvedRoots);
    }

    public static void remove(String moduleName, IModuleLayerManager.Layer layer) {
        ModuleRemover.remove(moduleName, LauncherAccessor.getModuleLayer(layer), ModuleLayerHandlerAccessor.getModuleClassLoader(layer));
    }

    public static void remove(Class<?> classInModule) {
        ModuleRemover.remove(classInModule.getModule().getName(), classInModule.getModule().getLayer(), (ModuleClassLoader)classInModule.getClassLoader());
    }
}

