/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.logging.log4j.Logger;
import settingdust.preloading_tricks.PreloadingTricks;

public final class ServiceLoaderUtil {
    public static Logger defaultLogger = PreloadingTricks.LOGGER;

    private ServiceLoaderUtil() {
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz, ModuleLayer layer) {
        return ServiceLoader.load(layer, clazz);
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz) {
        return ServiceLoader.load(clazz);
    }

    public static <T> T findService(Class<T> clazz, ServiceLoader<T> serviceLoader) {
        return ServiceLoaderUtil.findService(clazz, serviceLoader, defaultLogger);
    }

    public static <T> T findService(Class<T> clazz, ServiceLoader<T> serviceLoader, Logger logger) {
        Iterator<T> it = ServiceLoaderUtil.findServices(clazz, serviceLoader, logger, true).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        throw new NoSuchElementException("No service found for " + String.valueOf(clazz));
    }

    public static <T> Iterable<T> findServices(Class<T> clazz, ModuleLayer layer) {
        return ServiceLoaderUtil.findServices(clazz, ServiceLoaderUtil.load(clazz, layer), defaultLogger, true);
    }

    public static <T> Iterable<T> findServices(Class<T> clazz, ServiceLoader<T> serviceLoader, Logger logger, boolean required) {
        ArrayList<T> results = new ArrayList<T>();
        String prefix = "[" + logger.getName() + "] ";
        Iterator<ServiceLoader.Provider<T>> iterator = serviceLoader.stream().iterator();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        Optional<ServiceLoader.Provider<T>> current = ServiceLoaderUtil.findNext(iterator, errors);
        boolean found = false;
        while (current.isPresent()) {
            ServiceLoader.Provider<T> provider = current.get();
            String providerName = provider.type().getName();
            logger.debug("{}Loading {}", (Object)prefix, (Object)providerName);
            try {
                results.add(provider.get());
                found = true;
            }
            catch (Throwable t) {
                IllegalStateException e = new IllegalStateException(prefix + "Loading " + providerName + " failed", t);
                errors.add(e);
                logger.debug((Object)e);
            }
            current = ServiceLoaderUtil.findNext(iterator, errors);
        }
        if (!found && required) {
            IllegalStateException exception = new IllegalStateException("Load service of " + String.valueOf(clazz) + " failed");
            if (errors.isEmpty()) {
                exception.addSuppressed(new NoSuchElementException("Can't find service for " + String.valueOf(clazz)));
            }
            for (Throwable t : errors) {
                exception.addSuppressed(t);
            }
            throw exception;
        }
        return results;
    }

    public static <T> void loadServices(Class<T> clazz, ServiceLoader<T> serviceLoader, Logger logger, boolean required) {
        for (T t : ServiceLoaderUtil.findServices(clazz, serviceLoader, logger, required)) {
        }
    }

    private static <T> Optional<ServiceLoader.Provider<T>> findNext(Iterator<ServiceLoader.Provider<T>> iterator, List<Throwable> errors) {
        ServiceLoader.Provider<T> current = null;
        while (true) {
            try {
                if (!iterator.hasNext()) {
                    return Optional.empty();
                }
                current = iterator.next();
            }
            catch (NoSuchElementException e) {
                return Optional.empty();
            }
            catch (Throwable t) {
                errors.add(t);
                continue;
            }
            break;
        }
        return Optional.ofNullable(current);
    }

    public static <T> T findService(Class<T> clazz) {
        return ServiceLoaderUtil.findService(clazz, ServiceLoaderUtil.load(clazz), defaultLogger);
    }

    public static <T> Iterable<T> findServices(Class<T> clazz) {
        return ServiceLoaderUtil.findServices(clazz, ServiceLoaderUtil.load(clazz), defaultLogger, true);
    }

    public static <T> Iterable<T> findServices(Class<T> clazz, boolean required) {
        return ServiceLoaderUtil.findServices(clazz, ServiceLoaderUtil.load(clazz), defaultLogger, required);
    }

    public static <T> int loadServices(Class<T> clazz) {
        int count = 0;
        for (T ignored : ServiceLoaderUtil.findServices(clazz, ServiceLoaderUtil.load(clazz), defaultLogger, true)) {
            ++count;
        }
        return count;
    }
}

