/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.neoforge.fancy_mod_loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import net.lenni0451.reflect.Agents;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.locating.ModFileLoadingException;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.forgelike.JavaBypass;
import settingdust.preloading_tricks.forgelike.UnsafeHacks;
import settingdust.preloading_tricks.forgelike.class_transform.ClassTransformBootstrap;

public class PreloadingTricksBootstrapper
implements GraphicsBootstrapper {
    private static void appendToClassLoader(URL url, ClassLoader classLoader) throws Throwable {
        Field ucpField;
        try {
            ucpField = classLoader.getClass().getDeclaredField("ucp");
        }
        catch (NoSuchFieldException e) {
            ucpField = classLoader.getClass().getSuperclass().getDeclaredField("ucp");
        }
        Object ucp = UnsafeHacks.getField(ucpField, classLoader);
        Class<?> ucpClass = ucp.getClass();
        MethodHandle addURLHandle = JavaBypass.getTrustedLookup().in(ucpClass).findVirtual(ucpClass, "addURL", MethodType.methodType(Void.TYPE, URL.class));
        addURLHandle.invoke(ucp, url);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String extractEmbeddedJarFile(JarContents contents, String relativePath, Path destination) {
        try (InputStream inStream = contents.openFile(relativePath);){
            String string;
            block16: {
                OutputStream outStream = Files.newOutputStream(destination, new OpenOption[0]);
                try {
                    MessageDigest digest;
                    try {
                        digest = MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("Missing default JCA algorithm SHA-256.", e);
                    }
                    DigestOutputStream digestOut = new DigestOutputStream(outStream, digest);
                    inStream.transferTo(digestOut);
                    string = HexFormat.of().formatHex(digest.digest());
                    if (outStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outStream.close();
            }
            return string;
        }
        catch (IOException e) {
            PreloadingTricks.LOGGER.error("Failed to copy nested jar file {} from file {} to {}", (Object)relativePath, (Object)contents.getPrimaryPath(), (Object)destination, (Object)e);
            throw new ModFileLoadingException("Failed to load mod file " + String.valueOf(contents.getPrimaryPath().getFileName()), (Throwable)e);
        }
    }

    private static void moveExtractedFileIntoPlace(Path source, Path destination) {
        try {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create parent directory for extracted nested jar file " + String.valueOf(source) + " at " + String.valueOf(destination), e);
        }
        try {
            try {
                Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException ex) {
                Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to move temporary nested file " + String.valueOf(source) + " to its final location " + String.valueOf(destination), e);
        }
    }

    public PreloadingTricksBootstrapper() throws URISyntaxException, IOException {
        if (!(Thread.currentThread().getContextClassLoader() instanceof URLClassLoader)) {
            PreloadingTricks.LOGGER.debug("Looks like we are in older neoforge fancy mod loader. Needn't to run");
            return;
        }
        CodeSource codeSource = PreloadingTricksBootstrapper.class.getProtectionDomain().getCodeSource();
        Path rootPath = Path.of(codeSource.getLocation().toURI());
        JarContents contents = JarContents.ofPath((Path)rootPath);
        Path cachePath = Path.of(".cache", "preloading_tricks");
        try {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String prefix = "libs/boot";
        contents.visitContent(prefix, (relativePath, resource) -> {
            Path tempFile;
            if (!relativePath.endsWith(".jar")) {
                return;
            }
            try {
                tempFile = Files.createTempFile(cachePath, "_nested", ".tmp", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create a temporary file for nested jar in " + String.valueOf(cachePath) + ": " + String.valueOf(e));
            }
            try {
                String hash = PreloadingTricksBootstrapper.extractEmbeddedJarFile(contents, relativePath, tempFile);
                String filename = relativePath.substring(prefix.length() + 1);
                Path finalPath = cachePath.resolve(hash + "/" + filename);
                if (!Files.isRegularFile(finalPath, new LinkOption[0])) {
                    PreloadingTricksBootstrapper.moveExtractedFileIntoPlace(tempFile, finalPath);
                }
                try {
                    PreloadingTricksBootstrapper.appendToClassLoader(finalPath.toUri().toURL(), FMLLoader.class.getClassLoader());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException e) {
                    PreloadingTricks.LOGGER.error("Failed to remove temporary file {}: {}", (Object)tempFile, (Object)e);
                }
            }
        });
        new ClassTransformBootstrap();
        PreloadingTricks.LOGGER.info("[{}] Installed", (Object)"Preloading Tricks");
        ClassTransformBootstrap.INSTANCE.addConfig("preloading_tricks.neoforge.fml.classtransform.json");
        ClassTransformBootstrap.INSTANCE.getTransformerManager().hookInstrumentation(Agents.getInstrumentation());
    }

    public String name() {
        return "Preloading Tricks";
    }

    public void bootstrap(String[] arguments) {
    }
}

