/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.modlauncher.module_injector;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.Configuration;
import java.lang.module.ResolvedModule;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ConfigurationAccessor;
import settingdust.preloading_tricks.forgelike.module_injector.accessor.ModuleLayerAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleConfigurationCreator;
import settingdust.preloading_tricks.modlauncher.module_injector.ModuleOperationHelper;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.LauncherAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleClassLoaderAccessor;
import settingdust.preloading_tricks.modlauncher.module_injector.accessor.ModuleLayerHandlerAccessor;

public class ModuleInjector {
    public static void inject(Configuration moduleConfig, ModuleClassLoader targetClassLoader, ModuleLayer targetLayer) {
        Configuration targetConfiguration = ModuleClassLoaderAccessor.getConfiguration(targetClassLoader);
        ModuleOperationHelper.mergeConfigurations(targetConfiguration, moduleConfig);
        Set<ResolvedModule> allResolvedModules = ConfigurationAccessor.getModules(moduleConfig);
        for (ResolvedModule resolvedModule : allResolvedModules) {
            Set<ResolvedModule> reads = resolvedModule.reads();
            Module module = ModuleOperationHelper.createAndRegisterModule(resolvedModule, targetLayer, targetClassLoader, targetConfiguration);
            ModuleOperationHelper.setupModuleReads(module, targetLayer, reads);
        }
        ModuleLayerAccessor.clearModules(targetLayer);
        ModuleOperationHelper.updatePackageLookup(targetClassLoader, allResolvedModules);
        ModuleOperationHelper.updateResolvedRoots(targetClassLoader, allResolvedModules);
    }

    public static void inject(SecureJar jar, ModuleClassLoader targetClassLoader, ModuleLayer targetLayer) {
        Configuration moduleConfiguration = ModuleClassLoaderAccessor.getConfiguration(targetClassLoader);
        Configuration jarConfiguration = ModuleConfigurationCreator.createConfiguration(jar, moduleConfiguration);
        ModuleInjector.inject(jarConfiguration, targetClassLoader, targetLayer);
    }

    public static void inject(ModuleClassLoader targetClassLoader, ModuleLayer targetLayer, Path ... jarPaths) {
        SecureJar[] jars = (SecureJar[])Arrays.stream(jarPaths).map(xva$0 -> SecureJar.from((Path[])new Path[]{xva$0})).toArray(SecureJar[]::new);
        Configuration moduleConfiguration = ModuleClassLoaderAccessor.getConfiguration(targetClassLoader);
        Configuration jarConfiguration = ModuleConfigurationCreator.createConfiguration(moduleConfiguration, jars);
        ModuleInjector.inject(jarConfiguration, targetClassLoader, targetLayer);
    }

    public static void inject(ModuleClassLoader targetClassLoader, ModuleLayer targetLayer, SecureJar ... jars) {
        Configuration moduleConfiguration = ModuleClassLoaderAccessor.getConfiguration(targetClassLoader);
        Configuration jarConfiguration = ModuleConfigurationCreator.createConfiguration(moduleConfiguration, jars);
        ModuleInjector.inject(jarConfiguration, targetClassLoader, targetLayer);
    }

    public static void inject(IModuleLayerManager.Layer targetLayer, Path ... jarPaths) {
        ModuleInjector.inject(ModuleLayerHandlerAccessor.getModuleClassLoader(targetLayer), LauncherAccessor.getModuleLayer(targetLayer), jarPaths);
    }

    public static void inject(IModuleLayerManager.Layer targetLayer, SecureJar ... jars) {
        ModuleInjector.inject(ModuleLayerHandlerAccessor.getModuleClassLoader(targetLayer), LauncherAccessor.getModuleLayer(targetLayer), jars);
    }

    public static void inject(Class<?> targetClass, Path ... jarPaths) {
        ModuleInjector.inject((ModuleClassLoader)targetClass.getClassLoader(), targetClass.getModule().getLayer(), jarPaths);
    }

    public static void inject(Class<?> targetClass, SecureJar ... jars) {
        ModuleInjector.inject((ModuleClassLoader)targetClass.getClassLoader(), targetClass.getModule().getLayer(), jars);
    }
}

