/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.lexforge.virtual_mod;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.CodeSigner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

public final class VirtualJar
implements SecureJar,
Closeable {
    private static final UnionFileSystemProvider UFSP = (UnionFileSystemProvider)FileSystemProvider.installedProviders().stream().filter(fsp -> fsp.getScheme().equals("union")).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find UnionFileSystemProvider"));
    private final ModuleDescriptor moduleDescriptor;
    private final SecureJar.ModuleDataProvider moduleData = new VirtualJarModuleDataProvider();
    private final UnionFileSystem dummyFileSystem;
    private final Manifest manifest = new Manifest();

    public VirtualJar(String name, Path referencePath, String ... packages) {
        if (!Files.exists(referencePath, new LinkOption[0])) {
            throw new IllegalArgumentException("VirtualJar reference path " + String.valueOf(referencePath) + " must exist");
        }
        this.moduleDescriptor = ModuleDescriptor.newAutomaticModule(name).packages(Set.of(packages)).build();
        this.dummyFileSystem = UFSP.newFileSystem((path, basePath) -> path.equals("pack.mcmeta"), new Path[]{referencePath});
    }

    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleData;
    }

    public Path getPrimaryPath() {
        return this.dummyFileSystem.getPrimaryPath();
    }

    public CodeSigner[] getManifestSigners() {
        return null;
    }

    public SecureJar.Status verifyPath(Path path) {
        return SecureJar.Status.NONE;
    }

    public SecureJar.Status getFileStatus(String name) {
        return SecureJar.Status.NONE;
    }

    public Attributes getTrustedManifestEntries(String name) {
        return null;
    }

    public boolean hasSecurityData() {
        return false;
    }

    public Set<String> getPackages() {
        return this.moduleDescriptor.packages();
    }

    public List<SecureJar.Provider> getProviders() {
        return List.of();
    }

    public String name() {
        return this.moduleDescriptor.name();
    }

    public Path getPath(String first, String ... rest) {
        return this.dummyFileSystem.getPath(first, rest);
    }

    public Path getRootPath() {
        return this.dummyFileSystem.getRoot();
    }

    @Override
    public void close() throws IOException {
        this.dummyFileSystem.close();
    }

    private class VirtualJarModuleDataProvider
    implements SecureJar.ModuleDataProvider {
        private VirtualJarModuleDataProvider() {
        }

        public String name() {
            return VirtualJar.this.name();
        }

        public ModuleDescriptor descriptor() {
            return VirtualJar.this.moduleDescriptor;
        }

        @Nullable
        public URI uri() {
            return null;
        }

        public Optional<URI> findFile(String name) {
            return Optional.empty();
        }

        public Optional<InputStream> open(String name) {
            return Optional.empty();
        }

        public Manifest getManifest() {
            return VirtualJar.this.manifest;
        }

        @Nullable
        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return null;
        }
    }
}

