/*
 * Decompiled with CFR 0.152.
 */
package settingdust.preloading_tricks.fabric;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.discovery.ModCandidateFinder;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.discovery.ModDiscoverer;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.discovery.ModResolver;
import net.fabricmc.loader.impl.discovery.RuntimeModRemapper;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import settingdust.preloading_tricks.PreloadingTricks;
import settingdust.preloading_tricks.api.PreloadingTricksCallback;
import settingdust.preloading_tricks.api.PreloadingTricksModManager;
import settingdust.preloading_tricks.fabric.FabricModManager;
import settingdust.preloading_tricks.fabric.mod_candidate.DefinedModCandidateFinder;
import settingdust.preloading_tricks.fabric.mod_candidate.ModContainerModCandidateFinder;
import settingdust.preloading_tricks.fabric.util.FabricLoaderImplAccessor;

public class FabricPreloadingTricksCallback
implements PreloadingTricksCallback {
    @Override
    public void onSetupMods() {
        FabricModManager service = (FabricModManager)PreloadingTricksModManager.get();
        boolean remapRegularMods = FabricLoader.getInstance().isDevelopmentEnvironment();
        VersionOverrides versionOverrides = new VersionOverrides();
        DependencyOverrides dependencyOverrides = new DependencyOverrides(FabricLoaderImpl.INSTANCE.getConfigDir());
        ModDiscoverer discoverer = new ModDiscoverer(versionOverrides, dependencyOverrides);
        discoverer.addCandidateFinder((ModCandidateFinder)new DefinedModCandidateFinder(remapRegularMods));
        discoverer.addCandidateFinder((ModCandidateFinder)new ModContainerModCandidateFinder(service.all()));
        PreloadingTricksCallback.invoker.onCollectModCandidates();
        HashMap envDisabledMods = new HashMap();
        try {
            List modCandidates = discoverer.discoverMods(FabricLoaderImpl.INSTANCE, envDisabledMods);
            modCandidates = ModResolver.resolve((Collection)modCandidates, (EnvType)FabricLoader.getInstance().getEnvironmentType(), envDisabledMods);
            HashMap<String, ModCandidateImpl> idToCandidates = new HashMap<String, ModCandidateImpl>();
            for (ModCandidateImpl candidate : modCandidates) {
                idToCandidates.put(candidate.getId(), candidate);
                for (String provide : candidate.getProvides()) {
                    idToCandidates.put(provide, candidate);
                }
            }
            Iterator<Map.Entry<String, ModContainerImpl>> iterator = FabricLoaderImplAccessor.modMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ModContainerImpl> entry = iterator.next();
                String id = entry.getKey();
                ModContainerImpl modContainer = entry.getValue();
                if (Objects.equals(((ModCandidateImpl)idToCandidates.get(id)).getPaths(), modContainer.getCodeSourcePaths())) {
                    idToCandidates.remove(id);
                    continue;
                }
                iterator.remove();
                service.remove(modContainer);
            }
            FabricPreloadingTricksCallback.dumpModList(idToCandidates.values());
            FabricLoaderImpl.INSTANCE.dumpNonFabricMods(discoverer.getNonFabricMods());
            Path cacheDir = FabricLoader.getInstance().getGameDir().resolve(".fabric");
            Path outputDir = cacheDir.resolve("processedMods");
            if (remapRegularMods) {
                if (System.getProperty("fabric.remapClasspathFile") == null) {
                    PreloadingTricks.LOGGER.warn("Runtime mod remapping disabled due to no fabric.remapClasspathFile being specified. You may need to update loom.");
                } else {
                    RuntimeModRemapper.remap(idToCandidates.values(), (Path)cacheDir.resolve("tmp"), (Path)outputDir);
                }
            }
            for (ModCandidateImpl mod : idToCandidates.values()) {
                if (!mod.hasPath() && !mod.isBuiltin()) {
                    try {
                        mod.setPaths(Collections.singletonList(mod.copyToDir(outputDir, false)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error extracting mod " + String.valueOf(mod), e);
                    }
                }
                service.add(mod);
                for (Path path : mod.getPaths()) {
                    FabricLauncherBase.getLauncher().addToClassPath(path, new String[0]);
                }
            }
        }
        catch (ModResolutionException e) {
            FabricGuiEntry.displayCriticalError((Throwable)e, (boolean)true);
        }
    }

    public static void dumpModList(Collection<ModCandidateImpl> mods) {
        StringBuilder modListText = new StringBuilder();
        boolean[] lastItemOfNestLevel = new boolean[mods.size()];
        List<ModCandidateImpl> topLevelMods = mods.stream().filter(mod -> mod.getParentMods().isEmpty()).toList();
        int topLevelModsCount = topLevelMods.size();
        for (int i = 0; i < topLevelModsCount; ++i) {
            boolean lastItem;
            boolean bl = lastItem = i == topLevelModsCount - 1;
            if (lastItem) {
                lastItemOfNestLevel[0] = true;
            }
            FabricPreloadingTricksCallback.dumpModList0(topLevelMods.get(i), modListText, 0, lastItemOfNestLevel);
        }
        int modsCount = mods.size();
        PreloadingTricks.LOGGER.info("Loading {} additional mod{}:{}\n", (Object)modsCount, (Object)(modsCount != 1 ? "s" : ""), (Object)modListText);
    }

    private static void dumpModList0(ModCandidateImpl mod, StringBuilder log, int nestLevel, boolean[] lastItemOfNestLevel) {
        if (!log.isEmpty()) {
            log.append('\n');
        }
        for (int depth = 0; depth < nestLevel; ++depth) {
            log.append(depth == 0 ? "\t" : (lastItemOfNestLevel[depth] ? "     " : "   | "));
        }
        log.append(nestLevel == 0 ? "\t" : "  ");
        log.append(nestLevel == 0 ? "-" : (lastItemOfNestLevel[nestLevel] ? " \\--" : " |--"));
        log.append(' ');
        log.append(mod.getId());
        log.append(' ');
        log.append(mod.getVersion().getFriendlyString());
        ArrayList<ModCandidateImpl> nestedMods = new ArrayList<ModCandidateImpl>(mod.getNestedMods());
        nestedMods.sort(Comparator.comparing(nestedMod -> nestedMod.getMetadata().getId()));
        if (!nestedMods.isEmpty()) {
            Iterator iterator = nestedMods.iterator();
            while (iterator.hasNext()) {
                boolean lastItem;
                ModCandidateImpl nestedMod2 = (ModCandidateImpl)iterator.next();
                boolean bl = lastItem = !iterator.hasNext();
                if (lastItem) {
                    lastItemOfNestLevel[nestLevel + 1] = true;
                }
                FabricPreloadingTricksCallback.dumpModList0(nestedMod2, log, nestLevel + 1, lastItemOfNestLevel);
                if (!lastItem) continue;
                lastItemOfNestLevel[nestLevel + 1] = false;
            }
        }
    }
}

